% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FIESTA-package.R
\docType{package}
\name{FIESTA-package}
\alias{FIESTA-package}
\alias{FIESTA}
\title{EcoMap SpatialPolygonsDataFrame}
\description{
Contains regional geographic delineations for analysis of ecological
relationships across ecological units. ECOMAP is the term used for a USDA
Forest Service initiative to map ecological units and encourage their use in
ecosystem-based approaches to forest land conservation and management. It is
coordinated at the national and regional levels by USDA Forest Service staff
and implemented in cooperation with State forestry agencies and others.
ECOMAP mapping criteria are outlined in the National Hierarchical Framework
of Ecological Units (https://www.ncrs.fs.fed.us/gla/reports/hierarch-
y.htm). The framework systematically divides the country into progressively
smaller areas of land and water that have similar physical and biological
characteristics and ecological processes.
}
\details{
The EcoMap Provinces feature class contains ecological province polygons
attributed with names and descriptions. The EcomapSections 2007 data set
describes the ecological sections within the conterminous United States. The
EcomapSubections 2007 data set describes the ecological subsections within
the conterminous United States.

Converted to simple feature\cr Transformed CRS from longlat(EPSG:4269) to
Albers (EPSG:5070)\cr Saved to R object, with compression='xz'


FIESTA - Forest Inventory Estimation for Analysis

FIESTA is a research estimation tool for analysts that work with sample-based 
inventory data from the U.S. Department of Agriculture, Forest Service, 
Forest Inventory and Analysis (FIA) Program. 

FIESTA can generate FIA's traditional state-wide estimates while also accommodate: 
unique population boundaries, different evaluation time periods, customized 
stratification schemes, non-standard variance equations, integration of 
multi-scale remotely-sensed data and other auxiliary information, and 
interaction with other modeling and estimation tools from CRAN's library of 
packages. 

FIESTA contains a collection of functions that can query FIA databases, 
summarize and compile plot and spatial data, and generate estimates with 
associated sampling errors.
}
\references{
Bechtold, William A.; Patterson, Paul L.; [Editors] 2005. The enhanced
forest inventory and analysis program - national sampling design and
estimation procedures. Gen. Tech. Rep. SRS-80. Asheville, NC: U.S.
Department of Agriculture, Forest Service, Southern Research Station. 85p.

R Development Core Team (2011). R: A language and environment for
statistical computing. R Foundation for Statistical Computing, Vienna,
Austria. ISBN 3-900051-07-0, URL http://www.R-project.org/.

Burrill, E.A., Wilson, A.M., Turner, J.A., Pugh, S.A., Menlove, J.,
Christiansen, G., Conkling, B.L., Winnie, D., 2018. Forest Inventory and
Analysis Database [WWW Document].  St Paul MN US Dep. Agric. For. Serv.
North. Res. Stn.  URL http://apps.fs.fed.us/fiadb-downloads/datamart.html
(accessed 3.6.21).
}
\author{
Tracey S. Frescino Maintainer: Tracey S. Frescino
}
\keyword{package}
