% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FLOPART.R
\name{FLOPART_data}
\alias{FLOPART_data}
\title{Convert data for input to FLOPART}
\usage{
FLOPART_data(coverage, label)
}
\arguments{
\item{coverage}{data frame of coverage with columns chromStart,
chromEnd, count}

\item{label}{data frame of labels with with columns chromStart,
chromEnd, annotation}
}
\value{
named list: coverage_dt is data table representing a
  run-length encoding of the input coverage data, with additional
  rows if there are label chromStart/chromEnd values not in the
  set of coverage positions; label_dt is a data table with one row
  per label, and additional columns firstRow/lastRow which refer
  to row numbers of coverage_dt, 0-based for passing to C++ code.
}
\description{
FLOPART needs at most one label per coverage data row, which may
not be the case for arbitrary coverage/labels.
}
\examples{
library(data.table)
d <- function(chromStart, chromEnd, count){
  data.table(chromStart, chromEnd, count)
}
(cov.dt <- rbind(
  d(0, 10, 53),
  d(10, 20, 124)))
l <- function(chromStart, chromEnd, annotation){
  data.table(chromStart, chromEnd, annotation)
}
lab.dt <- rbind(
  l(2, 7, "noPeaks"),
  l(8, 15, "peakStart"))
FLOPART::FLOPART_data(cov.dt)
FLOPART::FLOPART_data(cov.dt, lab.dt)
data("Mono27ac", package="FLOPART")
sapply(Mono27ac, dim)
converted <- with(Mono27ac, FLOPART::FLOPART_data(coverage, labels))
sapply(converted, dim)
}
\author{
Toby Dylan Hocking
}
