% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codec.R
\name{codec}
\alias{codec}
\title{Estimate the conditional dependence coefficient (CODEC)}
\usage{
codec(Y, Z, X = NULL, na.rm = TRUE)
}
\arguments{
\item{Y}{Vector (length n)}

\item{Z}{Matrix (n by q)}

\item{X}{Matrix (n by p), default is NULL}

\item{na.rm}{Remove NAs if TRUE}
}
\value{
The conditional dependence coefficient (CODEC) of Y and Z given X. If X == NULL, this is just a
measure of the dependence between Y and Z.
}
\description{
The conditional dependence coefficient (CODEC) is a measure of the amount of conditional dependence between
a random variable Y and a random vector Z given a random vector X, based on an i.i.d. sample of (Y, Z, X).
The coefficient is asymptotically guaranteed to be between 0 and 1.
}
\details{
The value returned by codec can be positive or negative. Asymptotically, it is guaranteed
to be between 0 and 1. A small value indicates low conditional dependence between Y and Z given X, and
a high value indicates strong conditional dependence. The codec function is used by the  \code{\link{foci}} function
for variable selection.
}
\examples{
n = 1000
x <- matrix(runif(n * 2), nrow = n)
y <- (x[, 1] + x[, 2]) \%\% 1
# given x[, 1], y is a function of x[, 2]
codec(y, x[, 2], x[, 1])
# y is a function of x
codec(y, x)
z <- rnorm(n)
# y is a function of x given z
codec(y, x, z)
# y is independent of z given x
codec(y, z, x)
}
\references{
Azadkia, M. and Chatterjee, S. (2019). A simple measure
of conditional dependence.
\url{https://arxiv.org/pdf/1910.12327.pdf}.
}
\seealso{
\code{\link{foci}}, \code{\link[XICOR]{xicor}}
}
\author{
Mona Azadkia, Sourav Chatterjee, Norman Matloff
}
