% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometryfns.R
\name{STsphere}
\alias{STsphere}
\title{Space-time sphere}
\usage{
STsphere(radius = 6371)
}
\arguments{
\item{radius}{radius of sphere}
}
\description{
Initialisation of a 2-sphere (S2) with a temporal dimension
}
\details{
As with the spatial-only sphere, the sphere surface is initialised using a \code{radius} parameter. The default value of the radius \code{R} is \code{R}=6371 km, the Earth's radius, while the measure used to compute distances on the sphere is the great-circle distance on a sphere of radius \code{R}.
}
\examples{
S <- STsphere()
print(sp::dimensions(S))
}
