% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometryfns.R
\name{distances}
\alias{distances}
\alias{measure}
\alias{Euclid_dist}
\alias{gc_dist}
\alias{gc_dist_time}
\title{Pre-configured distances}
\usage{
measure(dist, dim)

Euclid_dist(dim = 2L)

gc_dist(R = NULL)

gc_dist_time(R = NULL)
}
\arguments{
\item{dist}{a function taking two arguments \code{x1,x2}}

\item{dim}{the dimension of the manifold (e.g., 2 for a plane)}

\item{R}{great-circle radius}
}
\description{
Useful objects of class \code{distance} included in package.
}
\details{
Initialises an object of class \code{measure} which contains a function \code{dist} used for computing the distance between two points.  Currently the Euclidean distance and the great-circle distance are included with \code{FRK}.
}
\examples{
M1 <- measure(distR,2)
D <- distance(M1,matrix(rnorm(10),5,2))
}
