% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basisfns.R
\name{Basis}
\alias{Basis}
\title{Generic basis-function constructor}
\usage{
Basis(manifold, n, fn, pars, df)
}
\arguments{
\item{manifold}{object of class \code{manifold}, for example, \code{sphere}}

\item{n}{number of basis functions (should be an integer)}

\item{fn}{a list of functions, one for each basis function. Each function should be encapsulated within an environment
in which the manifold and any other parameters required to evaluate the function are defined. The
function itself takes a single input \code{s} which can be of class \code{numeric}, \code{matrix}, or \code{Matrix},
and returns a vector which contains the basis function evaluations at \code{s}.}

\item{pars}{A list containing a list of parameters for each function. For local basis functions these would correspond
to location and scale parameters.}

\item{df}{A data frame containing one row per basis function, typically for providing informative summaries.}
}
\description{
This function is meant to be used for manual construction of arbitrary basis functions. For
'local' basis functions, please use the function \code{\link{local_basis}} instead.
}
\details{
This constructor checks that all the parameters are valid before constructing the basis functions
using \code{new}. The requirement that every function is encapsulated is tedious, but necessary for
FRK to work with a large range of basis functions in the future. Please see the example below which exemplifies
the process of constructing linear basis functions from scratch using this function.
}
\examples{
## Construct two linear basis functions on [0, 1]
manifold <- real_line()
n <- 2
lin_basis_fn <- function(manifold, grad, intercept) {
   function(s) grad*s + intercept
}
pars <- list(list(grad = 1, intercept = 0),
             list(grad = -1, intercept = 1))
fn <- list(lin_basis_fn(manifold, 1, 0),
           lin_basis_fn(manifold, -1, 1))
df <- data.frame(n = 1:2, grad = c(1, -1), m = c(1, -1))
G <- Basis(manifold = manifold, n = n, fn = fn, pars = pars, df = df)
\dontrun{
eval_basis(G, s = matrix(seq(0,1, by = 0.1), 11, 1))}
}
\seealso{
\code{\link{auto_basis}} for constructing basis functions automatically, \code{\link{local_basis}} for
constructing `local' basis functions, and \code{\link{show_basis}} for visualising basis functions.
}
