% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSAUtils.R
\name{rSquared}
\alias{rSquared}
\alias{rSquared.default}
\alias{rSquared.lm}
\alias{rSquared.default}
\alias{rSquared.lm}
\title{Extract the coefficient of determination from a linear model object.}
\usage{
rSquared(object, ...)

\method{rSquared}{default}(object, ...)

\method{rSquared}{lm}(object, digits = getOption("digits"), percent = FALSE,
  ...)
}
\arguments{
\item{object}{An object saved from \code{lm}.}

\item{\dots}{Additional arguments for methods.}

\item{digits}{A single number that is the number of digits to round the returned result to.}

\item{percent}{A logical that indicates if the result should be returned as a percentage (\code{=TRUE}) or as a proportion (\code{=FALSE}; default).}
}
\value{
A numeric, as either a proportion or percentage, that is the coefficient of determination for a linear model.
}
\description{
Extracts the coefficient of determination (i.e., \dQuote{r-squared} from a linear model (i.e., \code{lm}) object.
}
\details{
This is a convenience function to extract the \code{r.squared} part from \code{summary(lm)}.
}
\examples{
data(Mirex)
lm1 <- lm(mirex~weight, data=Mirex)
rSquared(lm1)
rSquared(lm1,digits=3)
rSquared(lm1,digits=1,percent=TRUE)

## rSquared only works with lm objects
\dontrun{
nls1 <- nls(mirex~a*weight^b,data=Mirex,start=list(a=1,b=1))
rSquared(nls1)
}

}
\keyword{misc}
