% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FSAUtils.R
\name{perc}
\alias{perc}
\title{Computes the percentage of values in a vector less than or greater than (and equal to) some value.}
\usage{
perc(x, val, dir = c("geq", "gt", "leq", "lt"), na.rm = TRUE,
  digits = getOption("digits"))
}
\arguments{
\item{x}{A numeric vector.}

\item{val}{A single numeric value.}

\item{dir}{A string that indicates whether the percentage is for values in \code{x} that are \dQuote{greater than and equal} \code{"geq"}, \dQuote{greater than} \code{"gt"}, \dQuote{less than and equal} \code{"leq"}, \dQuote{less than} \code{"lt"} the value in \code{val}.}

\item{na.rm}{A logical that indicates whether \code{NA} values should be removed (DEFAULT) from \code{x} or not.}

\item{digits}{A single numeric that indicates the number of decimals the percentage should be rounded to.}
}
\value{
A single numeric that is the percentage of values in \code{x} that meet the criterion in \code{dir} relative to \code{val}.
}
\description{
Computes the percentage of values in a vector less than or greater than (and equal to) a user-supplied value.
}
\details{
This function is most useful when used with an apply-type of function.
}
\examples{
## vector of values
( tmp <- c(1:8,NA,NA) )

## percentages excluding NA values
perc(tmp,5)
perc(tmp,5,"gt")
perc(tmp,5,"leq")
perc(tmp,5,"lt")

## percentages including NA values
perc(tmp,5,na.rm=FALSE)
perc(tmp,5,"gt",na.rm=FALSE)
perc(tmp,5,"leq",na.rm=FALSE)
perc(tmp,5,"lt",na.rm=FALSE)
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\keyword{misc}

