# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Selection Cutoffs for Ranked Attributes
#'
#' @param x1 Probably vector with attributes' names.
#' @param x2 Probably vector with attributes' ranks fo cut off.
#' @param k A numeric. For \code{k > 1} it indicates how many attributes to take
#' with the highest attribute rank (chooses k best attributes). For \code{0 < k  =< 1} it stands for the percent
#' of top attributes to take (chooses best k * 100% of attributes). For \code{k = 0} it selects top attributes
#' before the biggest gap in differences of scores for neighbouring attributes
#' (chooses a subset of attributes which are significantly better than other.)
#'
#' @author Damian Skrzypiec, \email{damian.j.skrzypiec@@gmail.com}
#'
#' @examples
#'
#' x = information_gain(Species ~ ., iris)
#' cutOff_k(rownames(x), x[[1]], 2)
#'
#' @noRd
cutOff_k <- function(x1, x2, k) {
    .Call('FSelectorRcpp_cutOff_k', PACKAGE = 'FSelectorRcpp', x1, x2, k)
}

discretize_cpp <- function(x, y, discControl) {
    .Call('FSelectorRcpp_discretize_cpp', PACKAGE = 'FSelectorRcpp', x, y, discControl)
}

information_gain_cpp <- function(xx, y, threads = 1L) {
    .Call('FSelectorRcpp_information_gain_cpp', PACKAGE = 'FSelectorRcpp', xx, y, threads)
}

sparse_information_gain_cpp <- function(x, y) {
    .Call('FSelectorRcpp_sparse_information_gain_cpp', PACKAGE = 'FSelectorRcpp', x, y)
}

fs_count_levels <- function(x) {
    .Call('FSelectorRcpp_fs_count_levels', PACKAGE = 'FSelectorRcpp', x)
}

fs_order <- function(x) {
    .Call('FSelectorRcpp_fs_order', PACKAGE = 'FSelectorRcpp', x)
}

fs_entropy1d <- function(x) {
    .Call('FSelectorRcpp_fs_entropy1d', PACKAGE = 'FSelectorRcpp', x)
}

fs_table1d <- function(x) {
    .Call('FSelectorRcpp_fs_table1d', PACKAGE = 'FSelectorRcpp', x)
}

fs_table_numeric2d <- function(x, y) {
    .Call('FSelectorRcpp_fs_table_numeric2d', PACKAGE = 'FSelectorRcpp', x, y)
}

