% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVST_linkfunction.R
\name{predict.krr}
\alias{predict.krr}
\title{Predict responses for new data using fitted KRR model}
\usage{
\method{predict}{krr}(object, newdata, ...)
}
\arguments{
\item{object}{A S3 object of class \code{krr} created by \code{\link{fastkrr}}.}

\item{newdata}{New design matrix or data frame containing new observations
for which predictions are to be made.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A numeric vector of predicted values corresponding to \code{newdata}.
}
\description{
Generates predictions from a fitted Kernel Ridge Regression (KRR) model
for new data.
}
\examples{
# Data setting
n = 30
d = 1
X = matrix(runif(n*d, 0, 1), nrow = n, ncol = d)
y = as.vector(sin(2*pi*rowMeans(X)^3) + rnorm(n, 0, 0.1))
lambda = 1e-4
rho = 1

# Fitting model: pivoted
model = fastkrr(X, y, kernel = "gaussian", rho = rho, lambda = lambda, opt = "pivoted")

# Predict
new_n = 50
new_x = matrix(runif(new_n*d, 0, 1), nrow = new_n, ncol = d)
new_y = as.vector(sin(2*pi*rowMeans(new_x)^3) + rnorm(new_n, 0, 0.1))

pred = predict(model, new_x)
crossprod(pred, new_y) / new_n
}
\seealso{
\code{\link{fastkrr}}, \code{\link{make_kernel}}
}
