% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{withSink}
\alias{withSink}
\title{Execute an expression while redirecting output to a file}
\usage{
withSink(expr, logfile = tempfile(fileext = ".txt"))
}
\arguments{
\item{expr}{The expression to execute}

\item{logfile}{The file to redirect output to. Default is "tmp.txt".}
}
\value{
The result of the expression
}
\description{
Execute an expression while redirecting output to a file
}
\examples{
logfile <- tempfile(fileext = ".txt")
withSink(logfile = logfile, expr = {
  cat("Helloworld\n")
  message("Goodbye")
})
readLines(logfile) == c("Helloworld", "Goodbye")
}
\keyword{internal}
