% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e_conversion.R
\name{pk2pk}
\alias{pk2pk}
\title{Global Conversion Function Between Kiener Distribution Parameters}
\usage{
pk2pk(coefk, model = "K2", to = "K7", dgts = NULL)
}
\arguments{
\item{coefk}{vectors of numeric of length 3, 4 or 7.}

\item{model}{character. Either "K1", "K2", "K3", "K4", "K7".}

\item{to}{character. Either "K1", "K2", "K3", "K4", "K7".}

\item{dgts}{integer. The rounding applied to the output.}
}
\description{
A conversion function between Kiener distribution parameters 
\code{K1(m, g, k)}, \code{K2(m, g, a, w)},
\code{K3(m, g, k, d)} and \code{K4(m, g, k, e)} to and from
\code{coefk = c(m, g, a, k, w, d, e)} extracted from \code{\link{regkienerLX}} 
and \code{\link{paramkienerX}}.
}
\details{
Kiener distributions use the following parameters, some of them being redundant. 
See also \code{\link{aw2k}} for the formulas and 
the conversion between parameters:
\itemize{
  \item{ \code{m} (mu) is the median of the distribution,. }
  \item{ \code{g} (gamma) is the scale parameter. }
  \item{ \code{a} (alpha) is the left tail parameter. } 
  \item{ \code{k} (kappa) is the harmonic mean of \code{a} and \code{w} 
         and describes a global tail parameter. }
  \item{ \code{w} (omega) is the right tail parameter. } 
  \item{ \code{d} (delta) is the distortion parameter. }
  \item{ \code{e} (epsilon) is the eccentricity parameter. }
}

\code{pk2pk()} performs the conversion between the various representation, from and to:
\itemize{
  \item{ "K1" : \code{kiener1(m, g, k)}    }
  \item{ "K2" : \code{kiener2(m, g, a, w)} }
  \item{ "K3" : \code{kiener3(m, g, k, d)} }
  \item{ "K4" : \code{kiener4(m, g, k, e)} }
  \item{ "K7" : \code{c(m, g, a, k, w, d, e)} }
}

\code{coefk} can take any of the above form. When length(coefk) is 4, 
\code{model = "K2", "K3" or "K4"} is required to differentiate the three models.
When length(coefk) is 3 or 7, recognition is automatic and  
\code{model = "K1" or "K7"} is ignored. The vector is assumed to be correct 
and there is no check of the consistency between the 
parameters \code{a, k, w, d} and \code{e}.

The output may be any of the above forms. Default is \code{"K7" = c(m, g, a, k, w, d, e)} 
which is \code{coefk} provided by the regression function \code{\link{regkienerLX}}
or the parameter estimation function \code{\link{paramkienerX}}. It is widely in many plots.

An integer rounding parameter is provided trough \code{dgts}. Default is no rounding.
}
\examples{

## Example 1
c2 <- c(1, 2, 3, 5)
pk2pk(c2, model = "K2", to = "K1") # loose the asymmetry.
pk2pk(c2, model = "K2", to = "K2")
pk2pk(c2, model = "K2", to = "K3")
pk2pk(c2, model = "K2", to = "K4")
pk2pk(c2, model = "K2", to = "K4")
(c7 <- pk2pk(c2, model = "K2", to = "K7", dgts = 3))
pk2pk(c7, model = "K7", to = "K2")

## Example 2 ("K2" to "K7")
(mat4 <- matrix( c(rep(0,9), rep(1,9), seq(0.5,4.5,0.5), seq(1,5,0.5)), 
         nrow = 4, byrow = TRUE, dimnames = list(c("m","g","a","w"), paste0("b",1:9))))
(mat7 <- round(apply(mat4, 2, pk2pk), 3))


}
\seealso{
Local conversion functions \code{\link{aw2k}}, 
Kiener distributions K1, K2, K3 and K4: \code{\link{kiener1}}, 
\code{\link{kiener2}}, \code{\link{kiener3}}, \code{\link{kiener4}}
}
