% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/matrix.R
\docType{class}
\name{CSCMatrix-class}
\alias{CSCMatrix-class}
\alias{[,CSCMatrix,missing,numeric,ANY-method}
\alias{[,CSCMatrix,numeric,missing,ANY-method}
\alias{[,CSCMatrix,numeric,numeric,ANY-method}
\alias{\%*\%,CSCMatrix,numeric-method}
\alias{\%*\%,numeric,CSCMatrix-method}
\alias{dim,CSCMatrix-method}
\alias{dim<-,CSCMatrix-method}
\title{CSCMatrix}
\description{
The structure of \code{CSCMatrix} is the same
as the structure of \code{dgCMatrix}. However, the
\code{CSCMatrix} has weaker constraints compared to \code{dgCMatrix}.

\code{CSCMatrix} onlysupports limited operators. The users can convert it to
\code{dgCMatrix} for compatibility of existed algorithms.
}
\details{
The \code{CSCMatrix} violates two constraints used in \code{dgCMatrix}:
\itemize{
 \item The row indices should be sorted with columns.
 \item The row indices should be unique with columns.
}
The result of matrix-vector multiplication should be the same.
}
\section{Methods}{

\itemize{
\item \code{dim} The dimension of the matrix object \code{CSCMatrix}.
\item \code{dim<-} The assignment of dimension of the matrix object \code{CSCMatrix}.
\item \code{[} The subsetting operator of the matrix object \code{CSCMatrix}.
\item \code{\%*\%} The matrix-vector multiplication of the matrix object \code{CSCMatrix}.
The returned object is a numeric vector.
}
}
\examples{
# construct a CSCMatrix
m <- hashed.model.matrix(~ ., CO2, 8)
# convert it to dgCMatrix
m2 <- as(m, "dgCMatrix")
}
\seealso{
\code{\link{dgCMatrix-class}}
}

