% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permmisclassrate.R
\name{PermMisClassRate}
\alias{PermMisClassRate}
\title{Permutation misclassification rate for single variable}
\usage{
PermMisClassRate(
  clusterObj,
  data,
  varName,
  basePred = NULL,
  predFUN = NULL,
  sub = 1,
  biter = 5,
  seed = 123
)
}
\arguments{
\item{clusterObj}{a "typical" cluster object. The only requirement is that there must be a prediction function which maps the data
to an integer}

\item{data}{data.table with the same features as the data set used for clustering (or the simply the same data)}

\item{varName}{character; variable name}

\item{basePred}{should be equal to results of predFUN(clusterObj,newdata=data); this option saves time when data is a very large data set}

\item{predFUN}{predFUN(clusterObj,newdata=data) should provide the cluster assignment as a numeric vector;
typically this is a wrapper around a build-in prediction function}

\item{sub}{integer between 0 and 1(=default), indicates that only a subset of the data should be used if <1}

\item{biter}{the permutation is iterated biter(=5, default) times}

\item{seed}{value for random seed}
}
\value{
vector of length biter with the misclassification rate
}
\description{
Answers the following question: Using the current partion as a baseline,
what is the misclassification rate if a given feature is permuted?
}
\examples{
set.seed(123)
dat <- create_random_data(n=1e3)$data # random data

library(flexclust)
res <- kcca(dat,k=4)
PermMisClassRate(res,dat,varName="x")

}
