% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field_trial_error.R
\name{field_trial_error}
\alias{field_trial_error}
\title{Simulate plot-level errors for a plant breeding trial}
\usage{
field_trial_error(
  n_envs,
  n_traits,
  n_reps,
  n_cols,
  n_rows,
  plot_length,
  plot_width,
  rep_dir = "column",
  var_R,
  S_cor_R = NULL,
  R_cor_R = NULL,
  spatial_model = "bivariate",
  prop_spatial = 0.5,
  complexity = 12,
  col_cor = NULL,
  row_cor = NULL,
  return_effects = FALSE
)
}
\arguments{
\item{n_envs}{Number of environments to be simulated (same as for \code{compsym_asr_input}
or \code{unstr_asr_output}, where applicable).}

\item{n_traits}{Number of traits to be simulated.}

\item{n_reps}{A vector defining the number of complete replicates in each environment. If only
one value is provided and \code{n_traits > 1}, all environments will be assigned the same
number of replicates.}

\item{n_cols}{A vector defining the total number of columns in each environment. If only one
value is provided and \code{n_traits > 1}, all environments will be assigned the same number
of columns.}

\item{n_rows}{A vector defining the total number of rows in each environment. If only one
value is provided and \code{n_traits > 1}, all environments will be assigned the same number
of rows.}

\item{plot_length}{A vector defining the plot length in each environment. If only one value is
provided and \code{n_traits > 1}, the plots in all environments will be assigned the same
plot length.}

\item{plot_width}{A vector defining the plot width in each environment. If only one value is
provided and \code{n_traits > 1}, the plots in all environments will be assigned the same
plot width.}

\item{rep_dir}{A character string specifying the direction of replicate blocks. One of either
"column" (side-by-side, the default) or "row" (above-and-below). \code{rep_dir} is ignored
when \code{n_reps = 1}.}

\item{var_R}{A vector of error variances for each trait-by-environment combination (ordered
as environments within traits). If the length of \code{var_R} is equal to \code{n_traits},
all traits will be assigned the same error variance in each environment.}

\item{S_cor_R}{A matrix of spatial error correlations between more than one trait. If not
defined and \code{n_traits > 1}, a diagonal matrix is constructed.}

\item{R_cor_R}{A matrix of random error correlations between more than one trait. If not
defined and \code{n_traits > 1}, a diagonal matrix is constructed.}

\item{spatial_model}{A character string specifying the model used to simulate the spatial error
term. One of either "Bivariate" (bivariate interpolation, the default) or "AR1:AR1"
(separable first-order autoregressive process (AR1:AR1)).}

\item{prop_spatial}{A vector defining the proportion of spatial error variance to total
error variance (spatial + random). If only one value is provided, all environments will be
assigned the same proportion. By default, the spatial error variance accounts for half of the
total error variance (\code{prop_spatial = 0.5}).}

\item{complexity}{A scalar defining the complexity of the bivariate interpolation model.
By default, \code{complexity = 12}. Note that low values may lead to convergence problems.
See \link[interp]{interp} for further details.}

\item{col_cor}{A vector of column autocorrelations for each environment used in the AR1:AR1
spatial error model. If only one value is provided, all environments will be assigned the
same column autocorrelation.}

\item{row_cor}{A vector of row autocorrelations for each environment used in the AR1:AR1
spatial error model. If only one value is provided, all environments will be assigned the
same row autocorrelation.}

\item{return_effects}{When true, a list is returned with additional entries for each trait
containing the spatial and random errors.}
}
\value{
A data-frame containing the environment, block, column and row names, as well as the
  simulated error for each trait. When \code{return_effects = TRUE}, a list is returned with
  additional entries for each trait containing the spatial and random errors.
}
\description{
Creates a data frame with simulated plot-level errors for one or more traits in plant breeding
trials across multiple environments. The simulated error consists of a spatial error term and
a random error term. The spatial error term can be simulated based on 1) bivariate
interpolation using the \link[interp]{interp} function of the package 'interp', or 2) a
separable first-order autoregressive process (AR1:AR1). The random error term is simulated
using an independent process. The spatial and random error terms are combined according to a
user-defined ratio. \cr
For multiple traits, correlated error terms can be generated assuming 1) correlated spatial
errors between traits, 2) correlated random error between traits, or 3) a combination of both. \cr
A separable covariance structure is assumed between traits and environments.
}
\examples{
# Simulation of plot-level errors for two traits in three environments using a bivariate
# interpolation model for spatial variation.

n_envs <- 3 # Number of simulated environments.
n_traits <- 2 # Number of simulated traits.

# Field layout
n_cols <- 10 # Total number of columns in each environment.
n_rows <- c(20, 30, 20) # Total number of rows in each environment.
plot_length <- 5 # Plot length set to 5 meters in each environment.
plot_width <- 2 # Plot width set to 2 meters in each environment.
n_reps <- c(2, 3, 2) # Number of complete replicates (blocks) per environment.

# Error variances for traits 1 and 2.
var_R <- c(0.4, 15)

# Spatial error correlations between traits 1 and 2.
S_cor_R <- matrix(c(
  1.0, 0.2,
  0.2, 1.0
),
ncol = 2
)

error_df <- field_trial_error(
  n_envs = n_envs,
  n_traits = n_traits,
  n_cols = n_cols,
  n_rows = n_rows,
  plot_length = plot_length,
  plot_width = plot_width,
  n_reps = n_reps,
  rep_dir = "row",
  var_R = var_R,
  S_cor_R = S_cor_R,
  spatial_model = "bivariate",
  prop_spatial = 0.6,
  complexity = 14,
  return_effects = TRUE
)
}
