% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{FisPro}
\alias{FisPro}
\alias{FisPro-package}
\title{FisPro package}
\description{
This package is a basic implementation of the main functions to use a "Fuzzy Inference System" that can be used for reasoning purposes, especially for simulating a physical or biological system. It is derived from the \href{https://www.fispro.org}{FisPro} open source software. Fuzzy inference systems are briefly described in the \href{https://www.fispro.org/documentation/en/inline-help/node39.html}{Fuzzy Logic Elementary Glossary}. They are based on fuzzy rules, which have a good capability for managing progressive phenomenons. Fuzzy logic, since the pioneer work by Zadeh, has proven to be a powerful interface between symbolic and numerical spaces. One of the reasons for this success is the ability of fuzzy systems to incorporate human expert knowledge with its nuances, as well as to express the behaviour of the system in an interpretable way for humans. Another reason is the possibility of designing data-driven FIS to make the most of available data.\cr
To design a fuzzy system that can be handled by this package the user can use the \href{https://www.fispro.org}{FisPro} software. If needed, the package can be extended to other functions. \cr
All the mentioned publications are available from the \href{https://www.fispro.org}{FisPro} web site.\cr
Enjoy \pkg{FisPro}!
}
\references{
{
\insertRef{Guillaume2011}{FisPro}

\insertRef{ExpertSystems12}{FisPro}
}
}
\seealso{
{
\url{https://www.fispro.org}
}
}
\author{
FisPro Team \email{contact@fispro.org}
}
