% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisin.R
\docType{class}
\name{FisIn}
\alias{FisIn}
\title{Class "Fisin"}
\description{
Class to manage a \link{Fis} input
}
\section{Fields}{

\describe{
\item{\code{name}}{\link{character} vector, The name of the input}
}}

\section{Constructors}{

\describe{
\item{\code{FisIn()}}{
The default constructor to build an empty input with the default range [0, 1]
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{FisIn} object}}
}

\item{\code{FisIn(minimum, maximum)}}{
The constructor to build an empty input
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{minimum}}{\link{numeric} value, The minimum range value of the input}
\item{argument: \code{maximum}}{\link{numeric} value, The maximum range value of the input}
\item{return:}{\link{FisIn} object}
}}

\item{\code{FisIn(number_of_mfs, minimum, maximum)}}{
The constructor to build an input with a regular standardized fuzzy partition
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{number_of_mfs}}{\link{integer} value, The number of Mfs in the fuzzy partition}
\item{argument: \code{minimum}}{\link{numeric} value, The minimum range value of the input}
\item{argument: \code{maximum}}{\link{numeric} value, The maximum range value of the input}
\item{return:}{\link{FisIn} object}
}}

\item{\code{FisIn(breakpoints, minimum, maximum)}}{
The constructor to build an input with an irregular standardized fuzzy partition
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{breakpoints}}{\link{numeric} vector, The breakpoint values (sorted in ascending order) of the Mfs in the fuzzy partition}
\item{argument: \code{minimum}}{\link{numeric} value, The minimum range value of the input}
\item{argument: \code{maximum}}{\link{numeric} value, The maximum range value of the input}
\item{return:}{\link{FisIn} object}
}}}
}

\section{Methods}{

\describe{
\item{\code{range()}}{
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{numeric} vector, The range of the input (min max values)}
}}

\item{\code{mf_size()}}{
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{integer} value, The number of Mfs in the input partition}
}}

\item{\code{add_mf(mf)}}{
Add an Mf in the input partition
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{mf}}{\link{Mf} object, The Mf to add}
}}

\item{\code{get_mf(mf_index)}}{
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{mf_index}}{\link{integer} value, The index (1-based index) of the mf to return}
\item{return:}{\link{Mf} object}
}}

\item{\code{get_mfs()}}{
Get all mfs in the input
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{list} of \link{Mf} objects}
}}

\item{\code{is_standardized()}}{
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{logical} value, \code{TRUE} if the input is a standardized fuzzy partition, \code{FALSE} otherwise}
}}}
}

\examples{
input <- NewFisIn(0, 2)
input$name <- "foo"
input$add_mf(NewMfTrapezoidalInf(0, 1))
input$add_mf(NewMfTriangular(0, 1, 2))
input$add_mf(NewMfTrapezoidalSup(1, 2))
}
\seealso{
{
\link{NewFisIn}

\href{https://www.fispro.org/documentation/en/inline-help/node39.html}{Fuzzy Logic Elementary Glossary}
}
}
