% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.slope.R
\name{QC.slope}
\alias{QC.slope}
\title{Quality Control of Slope(s)}
\usage{
QC.slope(slope.data, clean.data,
         chamber = c("CH1", "CH2", "CH3", "CH4",
                     "CH5", "CH6", "CH7", "CH8"),
         current = 9999, alter = 9999)
}
\arguments{
\item{slope.data}{a data frame obtained by using the function
\code{\link{extract.slope}}}

\item{clean.data}{a data frame obtained by using the function
\code{\link{correct.meas}}}

\item{chamber}{string: the chamber chosen for the QC test}

\item{current}{integer: current length of measurements for
slope estimation (in seconds)}

\item{alter}{integer: alternative length of measurements for
slope estimation (in seconds)}
}
\description{
Graphical quality control test of extracted slopes
represents a visual comparison of linear regression
of corrected O2 concenration over time with current
and alternative length of measurements.
}
\examples{
# if the data have been already loaded to R,
# skip the first five lines of the code:
setwd(path.package("FishResp", quiet = FALSE))
load("data/SMR.slope.RData")
load("data/SMR.clean.RData")
load("data/AMR.slope.RData")
load("data/AMR.clean.RData")

QC.slope(SMR.slope, SMR.clean,
         chamber = "CH1", current = 1200, alter = 600)
QC.slope(SMR.slope, SMR.clean,
         chamber = "CH2", current = 1200, alter = 600)
QC.slope(SMR.slope, SMR.clean,
         chamber = "CH3", current = 1200, alter = 600)
QC.slope(SMR.slope, SMR.clean,
         chamber = "CH4", current = 1200, alter = 600)

QC.slope(AMR.slope, AMR.clean,
         chamber = "CH1", current = 300, alter = 600)
QC.slope(AMR.slope, AMR.clean,
         chamber = "CH2", current = 300, alter = 600)
QC.slope(AMR.slope, AMR.clean,
         chamber = "CH3", current = 300, alter = 600)
QC.slope(AMR.slope, AMR.clean,
         chamber = "CH4", current = 300, alter = 600)

}
