% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgen.R
\name{rBeta_mu}
\alias{rBeta_mu}
\title{Random generator from the beta distribution}
\usage{
rBeta_mu(n, mu, phi)
}
\arguments{
\item{n}{the number of observations. If \code{length(n)} > 1, the length is taken to be the number required.}

\item{mu}{the mean parameter. It must lie in (0, 1).}

\item{phi}{the precision parameter. It must be a positive real value.}
}
\value{
A vector of length \code{n}.
}
\description{
The function randomly generates values from the beta distribution with a mean-precision parameterization.
}
\examples{
rBeta_mu(100, mu = 0.5, phi = 30)

}
\references{
{
Ferrari, S.L.P., and Cribari-Neto, F. (2004). Beta Regression for Modeling Rates and Proportions. Journal of Applied Statistics, \bold{31}(7), 799--815. doi:10.1080/0266476042000214501
}
}
