% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beta_functions.R
\name{dBeta}
\alias{dBeta}
\alias{qBeta}
\alias{pBeta}
\alias{rBeta}
\title{The Mean-Precision Parameterized Beta Distribution}
\usage{
dBeta(x, mu, phi, q0 = NULL, q1 = NULL, log = FALSE)

qBeta(prob, mu, phi, q0 = NULL, q1 = NULL, log.prob = FALSE)

pBeta(q, mu, phi, q0 = NULL, q1 = NULL, log.prob = FALSE)

rBeta(n, mu, phi, q0 = NULL, q1 = NULL)
}
\arguments{
\item{x, q}{a vector of quantiles.}

\item{mu}{the mean parameter. It must lie in (0, 1).}

\item{phi}{the precision parameter. It must be a real positive value.}

\item{q0}{the probability of augmentation in zero. It must lie in (0, 1). In case of no augmentation, it is \code{NULL} (default).}

\item{q1}{the probability of augmentation in one. It must lie in (0, 1). In case of no augmentation, it is \code{NULL} (default).}

\item{log}{logical; if TRUE, densities are returned on log-scale.}

\item{prob}{a vector of probabilities.}

\item{log.prob}{logical; if TRUE, probabilities \code{prob} are given as log(prob).}

\item{n}{the number of values to generate. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
The function \code{dBeta} returns a vector with the same length as \code{x} containing the density values.
The function \code{pBeta} returns a vector with the same length as \code{q} containing the values of the distribution function.
The function \code{qBeta} returns a vector with the same length as \code{prob} containing the quantiles.
The function \code{rBeta} returns a vector of length \code{n} containing the generated random values.
}
\description{
Density function, distribution function, quantile function, and random generation
for the (augmented) beta distribution with the mean-precision parameterization.
}
\details{
The beta distribution has density
\deqn{f_B(x;\mu,\phi)=\frac{\Gamma{(\phi)}}{\Gamma{(\mu\phi)}\Gamma{((1-\mu)\phi)}}x^{\mu\phi-1}(1-x)^{(1-\mu)\phi-1}}
for \eqn{0<x<1}, where \eqn{0<\mu<1} identifies the mean and \eqn{\phi>0} is the precision parameter.

The augmented beta distribution has density
\itemize{
\item \eqn{q_0},  if  \eqn{x=0}
\item \eqn{q_1}, if  \eqn{x=1}
\item \eqn{(1-q_0-q_1)f_B(x;\mu,\phi)}, if \eqn{0<x<1}
}
where \eqn{0<q_0<1} identifies the augmentation in zero, \eqn{0<q_1<1} identifies the augmentation in one,
and \eqn{q_0+q_1<1}.
}
\examples{
dBeta(x = c(.5,.7,.8), mu = .3, phi = 20)
dBeta(x = c(.5,.7,.8), mu = .3, phi = 20, q0 = .2)
dBeta(x = c(.5,.7,.8), mu = .3, phi = 20, q0 = .2, q1= .1)

qBeta(prob = c(.5,.7,.8), mu = .3, phi = 20)
qBeta(prob = c(.5,.7,.8), mu = .3, phi = 20, q0 = .2)
qBeta(prob = c(.5,.7,.8), mu = .3, phi = 20, q0 = .2, q1= .1)

pBeta(q = c(.5,.7,.8), mu = .3, phi = 20)
pBeta(q = c(.5,.7,.8), mu = .3, phi = 20, q0 = .2)
pBeta(q = c(.5,.7,.8), mu = .3, phi = 20, q0 = .2, q1= .1)

rBeta(n = 100, mu = .5, phi = 30)
rBeta(n = 100, mu = .5, phi = 30, q0 = .2, q1 = .1)

}
\references{
{
Ferrari, S.L.P., Cribari-Neto, F. (2004). Beta Regression for Modeling Rates and Proportions. Journal of Applied Statistics, \bold{31}(7), 799--815. doi:10.1080/0266476042000214501
}
}
