% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf_boughton.r
\name{bf_boughton}
\alias{bf_boughton}
\title{Boughton recursive digital filter}
\usage{
bf_boughton(discharge, k, C)
}
\arguments{
\item{discharge}{Nnumeric vector of daily flow data}

\item{k}{Numeric value of the recession constant (dimensionless).}

\item{C}{Numeric value of the partitioning factor (dimensionless).}
}
\value{
Returns a numeric vector of the estimated baseflow.
}
\description{
This function estimates baseflow
}
\examples{
data(cania.sub.ts)
res <- bf_boughton(cania.sub.ts$Flow, k=0.9, C=0.1)
plot(cania.sub.ts$Date, cania.sub.ts$Flow, xlab="", ylab="Q (m3/s)", type="l")
points(cania.sub.ts$Date, res, type="l", col="blue")
}
\references{
Boughton, WC. 1993. A hydrograph-based model for estimating the 
  water yield of ungauged catchments.In Hydrology and Water Resources Symposium,
  Institution of Engineers Australia, Newcastle, NSW; 317-324.
}
\author{
Paul H. Whitfield
}
