% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_ct.R
\name{ctcov}
\alias{ctcov}
\alias{ctcov.default}
\alias{ctcov.ols}
\alias{ctcov.str}
\alias{ctcov.csstr}
\alias{ctcov.testr}
\alias{ctcov.sam}
\alias{ctcov.wlsh}
\alias{ctcov.wlsv}
\alias{ctcov.shr}
\alias{ctcov.acov}
\alias{ctcov.Ssam}
\alias{ctcov.Sshr}
\alias{ctcov.bdshr}
\alias{ctcov.bdsam}
\alias{ctcov.hbshr}
\alias{ctcov.hbsam}
\alias{ctcov.hshr}
\alias{ctcov.hsam}
\alias{ctcov.bshr}
\alias{ctcov.bsam}
\title{Cross-temporal covariance matrix approximation}
\usage{
ctcov(comb = "ols", n = NULL, agg_mat = NULL, agg_order = NULL, res = NULL,
      tew = "sum", mse = TRUE, shrink_fun = shrink_estim, ...)
}
\arguments{
\item{comb}{A string specifying the reconciliation method.
\itemize{
\item Ordinary least squares:
\itemize{
\item "\code{ols}" (\emph{default}) - identity error covariance.
}
\item Weighted least squares:
\itemize{
\item "\code{str}" - structural variances.
\item "\code{csstr}" - cross-sectional structural variances.
\item "\code{testr}" - temporal structural variances.
\item "\code{wlsh}" - hierarchy variances (uses \code{res}).
\item "\code{wlsv}" - series variances (uses \code{res}).
}
\item Generalized least squares (uses \code{res}):
\itemize{
\item "\code{acov}" - series auto-covariance.
\item "\code{bdshr}"/"\code{bdsam}" - shrunk/sample block diagonal cross-sectional covariance.
\item "\code{Sshr}"/"\code{Ssam}" - series shrunk/sample covariance.
\item "\code{shr}"/"\code{sam}" - shrunk/sample covariance.
\item "\code{hbshr}"/"\code{hbsam}" - shrunk/sample high frequency bottom time series covariance.
\item "\code{bshr}"/"\code{bsam}" - shrunk/sample bottom time series covariance.
\item "\code{hshr}"/"\code{hsam}" - shrunk/sample high frequency covariance.
}
}}

\item{n}{Cross-sectional number of variables.}

\item{agg_mat}{A (\eqn{n_a \times n_b}) numeric matrix representing the cross-sectional
aggregation matrix. It maps the \eqn{n_b} bottom-level (free)
variables into the \eqn{n_a} upper (constrained) variables.}

\item{agg_order}{Highest available sampling frequency per seasonal cycle (max. order
of temporal aggregation, \eqn{m}), or a vector representing a subset of \eqn{p} factors
of \eqn{m}.}

\item{res}{A (\eqn{n \times N(k^\ast+m)}) optional numeric matrix containing the
in-sample residuals at all the temporal frequencies ordered from the lowest frequency
to the highest frequency (columns) for each variable (rows). This matrix is used
to compute some covariance matrices.}

\item{tew}{A string specifying the type of temporal aggregation. Options include:
"\code{sum}" (simple summation, \emph{default}), "\code{avg}" (average),
"\code{first}" (first value of the period), and "\code{last}"
(last value of the period).}

\item{mse}{If \code{TRUE} (\emph{default}) the residuals used to compute the covariance
matrix are not mean-corrected.}

\item{shrink_fun}{Shrinkage function of the covariance matrix, \link{shrink_estim} (\emph{default}).}

\item{...}{Not used.}
}
\value{
A (\eqn{n(k^\ast+m) \times n(k^\ast+m)}) symmetric matrix.
}
\description{
This function provides an approximation of the cross-temporal base forecasts errors
covariance matrix using different reconciliation methods (Di Fonzo and Girolimetto, 2023,
Girolimetto et al., 2023).
}
\examples{
set.seed(123)
# Aggregation matrix for Z = X + Y
A <- t(c(1,1))
# (3 x 70) in-sample residuals matrix (simulated),
# agg_order = 4 (annual-quarterly)
res <- rbind(rnorm(70), rnorm(70), rnorm(70))

cov1 <- ctcov("ols", n = 3, agg_order = 4)                     # OLS methods
cov2 <- ctcov("str", agg_mat = A, agg_order = 4)               # STR methods
cov3 <- ctcov("csstr", agg_mat = A, agg_order = 4)             # CSSTR methods
cov4 <- ctcov("testr", n = 3, agg_order = 4)                   # TESTR methods
cov5 <- ctcov("wlsv", agg_order = 4, res = res)                # WLSv methods
cov6 <- ctcov("wlsh", agg_order = 4, res = res)                # WLSh methods
cov7 <- ctcov("shr", agg_order = 4, res = res)                 # SHR methods
cov8 <- ctcov("sam", agg_order = 4, res = res)                 # SAM methods
cov9 <- ctcov("acov", agg_order = 4, res = res)                # ACOV methods
cov10 <- ctcov("Sshr", agg_order = 4, res = res)               # Sshr methods
cov11 <- ctcov("Ssam", agg_order = 4, res = res)               # Ssam methods
cov12 <- ctcov("hshr", agg_order = 4, res = res)               # Hshr methods
cov13 <- ctcov("hsam", agg_order = 4, res = res)               # Hsam methods
cov14 <- ctcov("hbshr", agg_mat = A, agg_order = 4, res = res) # HBshr methods
cov15 <- ctcov("hbsam", agg_mat = A, agg_order = 4, res = res) # HBsam methods
cov16 <- ctcov("bshr", agg_mat = A, agg_order = 4, res = res)  # Bshr methods
cov17 <- ctcov("bsam", agg_mat = A, agg_order = 4, res = res)  # Bsam methods
cov18 <- ctcov("bdshr", agg_order = 4, res = res)              # BDshr methods
cov19 <- ctcov("bdsam", agg_order = 4, res = res)              # BDsam methods

# Custom covariance matrix
ctcov.ols2 <- function(comb, x) diag(x)
cov20 <- ctcov(comb = "ols2", x = 21) # == ctcov("ols", n = 3, agg_order = 4)

}
\references{
Di Fonzo, T. and Girolimetto, D. (2023), Cross-temporal forecast reconciliation:
Optimal combination method and heuristic alternatives, \emph{International Journal
of Forecasting}, 39, 1, 39-57. \doi{10.1016/j.ijforecast.2021.08.004}

Girolimetto, D., Athanasopoulos, G., Di Fonzo, T. and Hyndman, R.J. (2024),
Cross-temporal probabilistic forecast reconciliation: Methodological and
practical issues. \emph{International Journal of Forecasting}, 40, 3, 1134-1151.
\doi{10.1016/j.ijforecast.2023.10.003}
}
\seealso{
Cross-temporal framework: 
\code{\link{ctboot}()},
\code{\link{ctbu}()},
\code{\link{ctlcc}()},
\code{\link{ctmo}()},
\code{\link{ctrec}()},
\code{\link{cttd}()},
\code{\link{cttools}()},
\code{\link{iterec}()},
\code{\link{tcsrec}()}
}
\concept{Framework: cross-temporal}
