% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/foreca.EM-aux.R
\name{foreca.EM-aux}
\alias{foreca.EM-aux}
\alias{foreca.EM.E_step}
\alias{foreca.EM.M_step}
\alias{foreca.EM.h}
\title{ForeCA EM auxiliary functions}
\usage{
foreca.EM.E_step(f.U, weightvector)

foreca.EM.M_step(f.U, f.current, minimize = TRUE, entropy.control = list())

foreca.EM.h(weightvector.new, f.U, weightvector.current = weightvector.new,
  f.current = NULL, entropy.control = list(), return.negative = FALSE)
}
\arguments{
\item{f.U}{multivariate spectrum of class \code{'mvspectrum'} with
\code{normalize = TRUE}.}

\item{weightvector}{numeric; weights \eqn{\mathbf{w}} for
\eqn{y_t = \mathbf{U}_t \mathbf{w}}. Must have unit norm in \eqn{\ell^2}.}

\item{f.current}{numeric; spectral density estimate of
\eqn{y_t=\mathbf{U}_t \mathbf{w}} for the current estimate
\eqn{\widehat{\mathbf{w}}_i} (required for
\code{foreca.EM.M_step}; optional for \code{foreca.EM.h}).}

\item{minimize}{logical; if \code{TRUE} (default) it returns the eigenvector
corresponding to the smallest eigenvalue; otherwise to the largest eigenvalue.}

\item{entropy.control}{list; control settings for entropy estimation.
See \code{\link{complete_entropy_control}} for details.}

\item{weightvector.new}{weightvector \eqn{\widehat{\mathbf{w}}_{i+1}} of the new
iteration (i+1).}

\item{weightvector.current}{weightvector \eqn{\widehat{\mathbf{w}}_{i}} of the
current iteration (i).}

\item{return.negative}{logical; if \code{TRUE} it returns the negative
spectral entropy. This is useful when maximizing forecastibility which is
equivalent (up to an additive constant) to maximizing negative entropy.
Default: \code{FALSE}.}
}
\value{
\code{foreca.EM.E_step} returns the normalized univariate spectral
density (normalized such that its \code{sum} equals \eqn{0.5}).

\code{foreca.EM.M_step} returns a list with three elements:
\itemize{
   \item \code{matrix}: weighted covariance matrix, where the weights are
         the negative log of the spectral density.  If density is estimated
         by discrete probabilities,
         then this \code{matrix} is positive semi-definite, since
         \eqn{-\log(p) \geq 0} for \eqn{p \in [0, 1]}.
         See \code{\link{weightvector2entropy_wcov}}.
   \item \code{vector}: minimizing (or maximizing if
         \code{minimize = FALSE}) eigenvector of \code{matrix},
   \item \code{value}: corresponding eigenvalue.
   }

\code{foreca.EM.h} returns non-negative real value (see References for details):
\itemize{
   \item entropy, if \code{weightvector.new = weightvector.current},
   \item an upper bound of that entropy for \code{weightvector.new},
         otherwise.
}
}
\description{
\code{foreca.EM.one_weightvector} relies on several auxiliary functions:

\code{foreca.EM.E_step} computes the spectral density of
\eqn{y_t=\mathbf{U}_t \mathbf{w}} given the weightvector \eqn{\mathbf{w}}
and the normalized spectrum estimate \eqn{f_{\mathbf{U}}}.
A wrapper around \code{\link{spectrum_of_linear_combination}}.

\code{foreca.EM.M_step} computes the minimizing eigenvector
(\eqn{\rightarrow \widehat{\mathbf{w}}_{i+1}}) of the weighted
covariance matrix, where the weights equal the negative logarithm of the
spectral density at the current \eqn{\widehat{\mathbf{w}}_i}.

\code{foreca.EM.h} evaluates (an upper bound of) the entropy of the spectral density as a function
of \eqn{\mathbf{w}_i} (or \eqn{\mathbf{w}_{i+1}}). This is the objective funcion that should be
\code{minimize}d.
}
\examples{
XX <- diff(log(EuStockMarkets)) * 100
UU <- whiten(XX)$U
ff <- mvspectrum(UU, 'wosa', normalize = TRUE)

ww0 <- initialize_weightvector(num.series = ncol(XX), method = 'rnorm')

f.ww0 <- foreca.EM.E_step(ff, ww0)
plot(f.ww0, type = "l")
one.step <- foreca.EM.M_step(ff, f.ww0,
                             entropy.control = list(prior.weight = 0.1))
image(one.step$matrix)
\dontrun{
requireNamespace(LICORS)
# if you have the 'LICORS' package use
LICORS::image2(one.step$matrix)
}
ww1 <- one.step$vector
f.ww1 <- foreca.EM.E_step(ff, ww1)

layout(matrix(1:2, ncol = 2))
matplot(seq(0, pi, length = length(f.ww0)), cbind(f.ww0, f.ww1),
        type = "l", lwd =2, xlab = "omega_j", ylab = "f(omega_j)")
plot(f.ww0, f.ww1, pch = ".", cex = 3, xlab = "iteration 0",
     ylab = "iteration 1", main = "Spectral density")
abline(0, 1, col = 'blue', lty = 2, lwd = 2)

Omega(mvspectrum.output = f.ww0) # start
Omega(mvspectrum.output = f.ww1) # improved after one iteration
foreca.EM.h(ww0, ff)       # iteration 0
foreca.EM.h(ww1, ff, ww0)  # min eigenvalue inequality
foreca.EM.h(ww1, ff)       # KL divergence inequality
one.step$value

# by definition of Omega, they should equal 1 (modulo rounding errors)
Omega(mvspectrum.output = f.ww0) / 100 + foreca.EM.h(ww0, ff)
Omega(mvspectrum.output = f.ww1) / 100 + foreca.EM.h(ww1, ff)
}
\seealso{
\code{\link{weightvector2entropy_wcov}}
}
\keyword{manip}
\keyword{math}

