% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbstractSimulatedIncidenceMatrix

%Two new commands to help with formatting
\newcommand{\methodtable}{\bold{\cr #1 \cr} \tabular{lcl}}
\newcommand{\methoditem}{\emph{#1} \tab-\tab #2\cr}
\newcommand{\methodname}{\subsection{#1}}
\docType{class}
\name{AbstractSimulatedIncidenceMatrix}
\alias{AbstractSimulatedIncidenceMatrix}
\title{AbstractSimulatedIncidenceMatrix}
\description{This class stores a number of simulations each of which contains the same data as an IncidenceMatrix.}
\seealso{
Inherits from : \code{\link{ArrayData}}

Is inherited by : \code{\link{SimulatedIncidenceMatrix}}}
\examples{
SimulatedIncidenceMatrix <- R6Class(
  classname = "SimulatedIncidenceMatrix",
  inherit = AbstractSimulatedIncidenceMatrix,
  private = list(
    .ndim = 3,
    ncore = 1,
    .sample = 1,
    parallelEnvironment = NULL
  ),
  public = list(
    initialize = function(data=MatrixData$new(),nsim=1)\{
      if('AbstractSimulatedIncidenceMatrix' \%in\% class(data))\{
        private$.arr= data$simulations
        private$.metaData = data$metaData
        private$.dimData = data$dimData
        private$.dnames = data$dnames
        private$.dims = data$dims
        private$.ndim = length(self$dims)
        return()
      \}
      else if('list' \%in\% class(data))\{
        if('MatrixData' \%in\% class(data[[1]]))\{
          if((!missing(nsim)) && (nsim != length(data)))\{
            stop("nsim is not used for list data.")
          \}
          private$.dims = c(data[[1]]$nrow,data[[1]]$ncol,length(data))
          private$.arr = array(NA,c(self$nrow,self$ncol,self$nsim))
          if(self$nsim > 0)\{
            for(i in 1: self$nsim)\{
              private$.arr[,,i] = data[[i]]$mat
            \}
          \}
          data = data[[1]]
          private$.metaData = data$metaData
          private$.dimData = list(data$rowData,data$colData)
          if(!is.null(data$rnames))\{
            if(!is.null(data$cnames))\{
              private$.dnames = list(data$rnames,data$cnames,NULL)
            \} else\{
              private$.dnames = list(data$rnames,NULL,NULL)
            \}
          \} else if(!is.null(data$cnames))\{
            private$.dnames = list(NULL,data$cnames,NULL)
          \} else \{
            private$.dnames = NULL
          \}
          dimnames(private$.arr) = private$.dnames
          private$.dims = c(data$nrow,data$ncol,nsim)
          private$.ndim = 3
          return()
        \}
        else\{
          stop("Not yet implemented")
        \}
      \} else if('MatrixData' \%in\% class(data))\{
        private$.arr= array(data$mat,c(data$nrow,data$ncol,nsim))
        private$.metaData = data$metaData
        private$.dimData = list(data$rowData,data$colData)
        if(!is.null(data$rnames))\{
          if(!is.null(data$cnames))\{
            private$.dnames = list(data$rnames,data$cnames,NULL)
          \} else\{
            private$.dnames = list(data$rnames,NULL,NULL)
          \}
        \} else if(!is.null(data$cnames))\{
          private$.dnames = list(NULL,data$cnames,NULL)
        \} else \{
          private$.dnames = NULL
        \}
        dimnames(private$.arr) = private$.dnames
        private$.dims = c(data$nrow,data$ncol,nsim)
        private$.ndim = 3
        return()
      \}
      else\{
        stop("Input data is not a valid type to make a SimulatedIncidenceMatrix")
      \}
      stop("This is currently broken.")
      rownames(private$.arr) <- rownames(data[[1]]$mat)
      colnames(private$.arr) <- colnames(data[[1]]$mat)
      private$.dimData = list(data$rowData,data$colData,NULL)
      private$.metaData = data$metaData
      if(!is.null(data$rnames))\{
        if(!is.null(data$cnames))\{
          private$.dnames = list(data$rnames,data$cnames,NULL)
        \} else\{
          private$.dnames = list(data$rnames,NULL,NULL)
        \}
      \} else if(!is.null(data$cnames))\{
        private$.dnames = list(NULL,data$cnames,NULL)
      \} else \{
        private$.dnames = NULL
      \}
      private$.dims = c(data$nrow,data$ncol,nsim)
    \},
    mean = function()\{
      "Compute the mean across simulations"
      if('mean' \%in\% private$.debug)\{
        browser()
      \}
      return(IncidenceMatrix$new(apply(self$simulations,c(1,2),mean)))
    \},
    median = function()\{
      if('median' \%in\% private$.debug)\{
        browser()
      \}
      return(IncidenceMatrix$new(apply(self$arr,c(1,2),median)))
    \},
    addError = function(type,rows,cols,mutate = TRUE)\{
      if('addError' \%in\% private$.debug)\{
        browser()
      \}
      if(missing(rows))\{
        rows = 1:self$nrow
      \}
      if(missing(cols))\{
        cols = 1:self$ncol
      \}
      if(type=='Poisson')\{
        private$.arr[rows,cols,] =
          rpois(length(rows)*length(cols)*self$nsim,self$arr[rows,cols,])
      \} else\{
        stop("Not yet implemented")
      \}
    \},
    subsample = function(simulations,mutate=TRUE)\{
      if('subsample' \%in\% private$.debug)\{
        browser()
      \}
      if(!mutate)\{
        rc = self$clone(TRUE)
        rc$subsample(simulations,mutate=TRUE)
        return(rc)
      \}
      if(
      (min(simulations) < 0) ||
        (max(simulations) > self$nsim) ||
        any(round(simulations) != simulations)
      )\{
        stop("simulations out of bounds.")
      \}
      private$.dims[3] = length(simulations)
      private$.arr = self$arr[,,simulations]
    \},
    subset = function(rows,cols,mutate=TRUE)\{
      if('subset' \%in\% private$.debug)\{
        browser()
      \}
      if(!mutate)\{
        rc = self$clone(TRUE)
        rc$subset(rows,cols,mutate=TRUE)
        return(rc)
      \}

      if(missing(rows) && missing(cols))\{
        return()
      \}
      else if(missing(rows))\{
        rows = 1:self$nrow
      \}
      else if(missing(cols))\{
        cols = 1:self$ncol
      \}
      private$.arr = self$arr[rows,cols,,drop=FALSE]
      private$.dims = c(nrow(self$arr),ncol(self$arr),self$nsim)
      private$.dnames = dimnames(self$arr)
      if(length(self$rowData)>0)\{
        if(length(self$colData) > 0)\{
          self$dimData = list(
            lapply(self$rowData,function(x)\{x[rows,drop=FALSE]\}),
            lapply(self$colData,function(x)\{x[cols,drop=FALSE]\})
          )
        \} else \{
          self$rowData <- lapply(self$rowData,function(x)\{x[rows,drop=FALSE]\})
        \}
      \} else if(length(self$colData)>0)\{
        self$colData <- lapply(self$colData,function(x)\{x[cols,drop=FALSE]\})
      \}
    \},
    head = function(k,direction=2,mutate=FALSE)\{

      if('head' \%in\% private$.debug)\{
        browser()
      \}
      if(k>dim(self$arr)[[direction]])\{
        stop("The size of the head is too large.")
      \}
      indices = 1:k

      if(direction==1)\{
        private$.arr = self$arr[indices,,,drop=FALSE]
        if(length(self$rowData)>0)\{
          private$.dimData[[1]] =
            lapply(self$rowData,function(x)\{x[indices,drop=FALSE]\})
        \}
      \}
      else if(direction==2)\{
        private$.arr = self$arr[,indices,,drop=FALSE]
        if(length(self$colData)>0)\{
          private$.dimData[[2]] =
            lapply(self$colData,function(x)\{x[indices,drop=FALSE]\})
        \}
      \}
      else\{
        stop("This direction is not allowed.")
      \}
      private$.dims = dim(self$arr)
      private$.dnames = dimnames(self$arr)
    \},
    tail = function(k,direction=2)\{

      if('tail' \%in\% private$.debug)\{
        browser()
      \}
      if(k>dim(self$arr)[[direction]])\{
        stop("The size of the tail is too large.")
      \}
      indices = (dim(self$arr)[[direction]]-k+1):dim(self$arr)[[direction]]

      if(direction==1)\{
        private$.arr = self$arr[indices,,,drop=FALSE]
        private$.dims = dim(self$arr)
        if(length(self$rowData)>0)\{
          self$rowData = lapply(self$rowData,function(x)\{x[indices,drop=FALSE]\})
        \}
      \}
      else if(direction==2)\{
        private$.arr = self$arr[,indices,,drop=FALSE]
        private$.dims = dim(self$arr)
        if(length(self$colData)>0)\{
          self$colData = lapply(self$colData,function(x)\{x[indices,drop=FALSE]\})
        \}
      \}
      else\{
        stop("This direction is not allowed.")
      \}
      private$.dims = dim(self$arr)
      private$.ndim = length(self$dims)
      private$.dnames = dimnames(self$arr)
    \},
    lag = function(indices,mutate = TRUE,na.rm=FALSE)\{
      if('lag' \%in\% private$.debug)\{
        browser()
      \}
      if(mutate==FALSE)\{
        tmp = self$clone(TRUE)
        tmp$lag(indices=indices,mutate=TRUE)
        return(tmp)
      \}
      if((1+max(indices)) > self$ncol)\{
        stop("We cannot go further back than the start of the matrix")
      \}
      numLags = length(indices)
      if(is.null(rownames(self$arr)))\{
        rownames(private$.arr) = 1:(dim(self$arr)[[1]])
      \}
      rownames = replicate(numLags,rownames(self$arr))
      colnames = colnames(self$arr)
      private$.arr <- array(self$arr,c(dim(self$arr),numLags))
      if(numLags <= 0)\{
        stop("indices must be nonempty for the calculation of lags to make sense.")
      \}
      for(lag in 1:numLags)\{
        private$.arr[,(1+indices[[lag]]):self$ncol,,lag] <-
          self$arr[,1:(self$ncol-indices[[lag]]),,lag]
        if(indices[[lag]] > 0)\{
          private$.arr[,1:(indices[[lag]]),,lag] = NA
        \}
      \}

      private$.arr = aperm(self$arr,c(1,4,2,3))
      private$.arr = array(self$arr,c(self$nrow*numLags,self$ncol,self$nsim))

      lagnames = t(replicate(self$nrow,paste('L',indices,sep='')))

      rownames(private$.arr) <-
        as.character(
          array(paste(lagnames,"R",rownames,sep=''),numLags*self$nrow)
        )
      colnames(private$.arr) <- colnames

      private$.dims[[1]] = self$nrow * numLags
      if(!is.null(dimnames(self$arr)))\{
        private$.dnames = dimnames(self$arr)
      \}
      if(length(self$rowData) > 0)\{
        self$rowData <- lapply(
          self$rowData,
          function(x)\{
            c(unlist(recursive=FALSE,lapply(1:numLags,function(y)\{x\})))
          \}
        )
      \}
      if(na.rm==TRUE)\{
        self$subset(cols=!apply(self$arr,2,function(x)\{any(is.na(x))\}))
      \}
    \},
    addRows = function(rows)\{
      if('addRows' \%in\% private$.debug)\{
        browser()
      \}
      if(rows == 0)\{
        return()
      \}
      abind(self$arr,array(NA,c(rows,self$ncol,self$nsim)),along=1) ->
        private$.arr
      private$.dims[[1]] = nrow(self$arr)
      private$.dnames = dimnames(self$arr)
      if(length(self$rowData) > 0)\{
        self$rowData = lapply(self$rowData,function(x)\{c(x,replicate(rows,NA))\})
      \}
    \},
    addColumns = function(columns)\{
      "This function adds columns to the data."
      "@param columns The number of columns to add."
      if('addColumns' \%in\% private$.debug)\{
        browser()
      \}

      if(columns == 0)\{
        return()
      \}
      abind(private$.arr,array(NA,c(self$nrow,columns,self$nsim)),along=2) ->
        private$.arr
      private$.dims[2]= ncol(self$arr)
      private$.dnames = dimnames(private$.arr)
      if(length(self$colData) > 0)\{
        self$colData = lapply(self$colData,function(x)\{c(x,replicate(columns,NA))\})
      \}
    \},
    scale = function(f,mutate=TRUE)\{
      if('scale' \%in\% private$.debug)\{
        browser()
      \}
      if(!mutate)\{
        tmp = self$clone(TRUE)
        tmp$scale(f=f,mutate=TRUE)
        return(tmp)
      \}
      private$.arr[] = f(private$.arr[])
    \},
    diff = function(lag = 1,mutate=TRUE)\{
      if('diff' \%in\% private$.debug)\{
        browser()
      \}
      if(!mutate)\{
        tmp = self$clone(TRUE)
        tmp$diff(lag=lag,mutate=TRUE)
        return(tmp)
      \}
      if(lag == 0)\{
        if(!is.null(rownames(private$.arr)))\{
          rownames(private$.arr) = paste("D",lag,"R",rownames(private$.arr),sep='')
        \}
        private$.dnames = dimnames(private$.arr)
        return()
      \}
      if(lag < 0)\{
        stop("lag must be non-negative.")
      \}
      rn = rownames(private$.arr)
      private$.arr <-
        self$simulations- self$lag(indices=lag,mutate=FALSE)$simulations
      if(!is.null(rn))\{
        rownames(private$.arr) = paste("D",lag,"R",rownames(private$.arr),sep='')
      \}
      private$.dnames = dimnames(private$.arr)
    \},
    mutate = function(rows,cols,data)\{
      if('mutate' \%in\% private$.debug)\{
        browser()
      \}
      tmpdata = data
      tmpdata = array(data,self$dims)
      data = as.array(data)

      if(missing(rows))\{
        rows = 1:self$nrow
        if(!(is.null(self$cnames) || is.null(colnames(data))))\{
          private$.dnames[[2]][cols] = colnames(data)
          colnames(private$.arr) = self$cnames
        \}
      \}
      if(missing(cols))\{
        cols = 1:self$ncol
        if(!(is.null(self$rnames) || is.null(rownames(data))))\{
          private$.dnames[[1]][rows] = rownames(data)
          rownames(private$.arr) = self$rnames
        \}
      \}
      if(is.null(dim(data)))\{
        stop("Not yet implemented for non-matrixlike objects")
      \}
      if(length(dim(data)) > 3)\{
        stop("There are too many dimensions in data.")
      \}
      if(length(dim(data)) == 3)\{
        if(dim(data)[[3]] == self$nsim)\{
          private$.arr[rows,cols,] = data
        \} else if(dim(data)[[3]] == 1)\{
          private$.arr[rows,cols,] = replicate(self$nsim,data)
        \}
      \}
      else\{
        private$.arr[rows,cols,] = replicate(self$nsim,data)
      \}
    \},
    summarize = function(FUNC,...)\{
      if('apply' \%in\% private$.debug)\{
        browser()
      \}
      return(IncidenceMatrix$new(
        data=apply(private$.arr,c(1,2),FUNC),
        rowData=self$rowData,
        colData=self$colData,
        metaData=self$metaData)
      )
    \}
  ),
  active = list(
    sample = function(value)\{
      "Randomly extract a simulation"
      if("sample" \%in\% private$.debug)\{
        browser()
      \}
      return = FALSE
      if(missing(value))\{
        if(self$nsim < 1)\{
          return(private$.arr)
        \}
        value = sample(self$nsim,1)
        return = TRUE
      \}
      if(floor(value) != value)\{
        stop("sample must be an integer.")
      \}

      private$.sample = value

      if(return)\{
        return(IncidenceMatrix$new(self))
      \}
    \},
    mat = function(value)\{
      private$.mat = adrop(private$.arr[,,private$.sample,drop=FALSE],3)
      rownames(private$.mat) = rownames(private$.arr)
      colnames(private$.mat) = colnames(private$.arr)
      return(private$.mat)
    \},
    simulations = function(value)\{
      if(missing(value))\{
        return(private$.arr)
      \}
      stop("Do not write directly to the simulations")
    \}
  )
)
}
\section{Fields}{
\describe{
\item{arr}{This is the full array.  For extensibility, it cannot be written to directly and must be modified through methods.}
\item{cnames}{The names of columns in the data.}
\item{colData}{A list of metadata associated with the columns of the data.}
\item{dimData}{The data associated with each dimension of the array.}
\item{dims}{The size of the array.}
\item{dnames}{The size of the array.}
\item{mat}{This is the matrix.  For extensibility, it cannot be written to directly and must be modified through methods.}
\item{metaData}{Any data not part of the main data structure.}
\item{ncol}{The number of columns in the data.}
\item{ndim}{The number of dimensions of the array.}
\item{nrow}{The number of rows in the data}
\item{nsim}{The number of simulations in \code{self$simulaions}}
\item{rnames}{The names of rows in the data.}
\item{rowData}{A list of metadata associated with the rows of the data.}
\item{sample}{An IncidenceMatrix sampled from the simulations.}
\item{simulations}{ The array of simulations.  This is another name for 'arr'.}
}}
\section{Methods}{
\methodname{addColumns(columns,mutate=TRUE)}{
This method \bold{must} be extended.  This function adds empty columns to the right side of the data.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{columns}{The number of columns to add.}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{addError(type)}{
This method \bold{must} be extended.  Add error of a particular type to the data.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{type}{What sort of error to add.}
}}}}
\methodname{addRows(rows,mutate=TRUE)}{
This method \bold{must} be extended.  This function adds empty rows to the right side of the data.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{rows}{The number of rows to add.}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{debug(string)}{
A function for debugging the methods of this class.  It calls the \link{browser} command.  In order for methods to opt into to debugging, they need to implement the following code at the beginning: if(<method_name> \%in\% private$.debug)\{browser()\}.  This method exists, because the debugger is not always intuitive when it comes to debugging R6 methods.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of methods to debug as a character vector}
}}}}
\methodname{diff(lag=1,mutate=TRUE)}{
This method \bold{must} be extended.  This function replaces the matrix value at column i with the difference. between the values at columns i and (i-lag).
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{lag}{ How far back to diff.  Defaults to 1.}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{head(k,direction,mutate=TRUE...)}{
This method \bold{must} be extended.  Select the first k slices of the data in dimension direction.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{k}{The number of slices to keep.}
\methoditem{direction}{The dimension to take a subset of. 1 for row, 2 for column.}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{initialize(...)}{
This function \bold{should} be extended. Create a new instance of this class.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{\dots}{This function should take in any arguments just in case.}
}}}}
\methodname{lag(indices,mutate=TRUE)}{
This method \bold{must} be extended.  This function replaces the current matrix with a new matrix with one  column for every column, and a row for every row/index combination.  The column corresponding to the row and index will have the value of the  original matrix in the same row, but index columns previous.  This  shift will introduce NAs where it passes off the end of the matrix.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{indices}{A sequence of lags to use as part of the data.  Note that unless this list contains \\code{0}, the data will all be shifted back by at least one year.}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{mutate(rows,cols,data)}{
This method \bold{must} be extended.  This function is a way to modify the data as though it were a matrix.  \code{self$mutate(row,col,data)} is equivalent to \code{self$mat[row,col] <- data}.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{rows}{Which rows to modify.  These can be numeric or names.}
\methoditem{cols}{Which cols to modify.  These can be numeric or names.}
\methoditem{data}{The data to change the chosen values to.  It needs to be the right shape.}
}}}}
\methodname{scale(f,mutate=TRUE)}{
This method \bold{must} be extended.  This function rescales each element of our object according to f
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{f}{a function which takes in a number and outputs a rescaled version of that number}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{subsample(simulations,mutate=TRUE...)}{
This method \bold{must} be extended.  Select only some of the simulations.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{simulations}{An index or list of column indices which simulations to keep.}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{subset(rows,cols,mutate=TRUE...)}{
This method \bold{must} be extended.  Select the data corresponding to the rows \code{rows} and the columns \code{columns}.  \code{rows} and \code{columns} can be either numeric or named indices.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{rows}{An row index or list of row indices which can be either numeric or named.}
\methoditem{cols}{An column index or list of column indices which can be either numeric or named.}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{summarize(FUNC)}{
This method \bold{must} be extended.  Apply a function FUNC to every simulation elementwise.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{FUNC}{a function which should be applied to every simulation.  It should reduce each simulation to a single number.}
}}
\item{Value}{A MatrixData where \code{return$mat} is \code{FUNC} applied to every simulation.}
}}
\methodname{tail(k,direction,mutate=TRUE...)}{
This method \bold{must} be extended.  Select the last \code{k} slices of the data in dimension \code{direction}.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{k}{The number of slices to keep.}
\methoditem{direction}{The dimension to take a subset of. 1 for row, 2 for column.}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{undebug(string)}{
A function for ceasing to debug methods.  Normally a method will call the \link{browser} command every time it is run.  This command will stop it from doing so.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of the methods to stop debugging.}
}}}}
}
