% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_species_tum_wwk_long.R
\name{fe_species_tum_wwk_long}
\alias{fe_species_tum_wwk_long}
\title{Construct a \emph{fe_species_tum_wwk_long} Species Code Vector}
\usage{
fe_species_tum_wwk_long(x = character())
}
\arguments{
\item{x}{Input vector to become a vector of tree species codes by the
definition \emph{tum_wwk_long}. Any type of vector (typically \code{integer})
which, after conversion with \code{\link{as.character}}, adheres to that
definition is acceptable. If \code{x} is provided as a character vector,
leading and trailing white spaces will be trimmed.}
}
\value{
If the user input allows to construct a well-defined
\code{fe_species_ger_nfi_2012} object, this object will be returned. If
not, the function will terminate with an error.
}
\description{
User interface for constructing a vector of species codes follwing the
\emph{fe_species_tum_wwk_long} convention
}
\details{
The \emph{tum_wwk_long} species coding is one of two codings in use at the Chair
of Forest Growth and Yield Science (see \code{\link{species_codings}} for
more information). See the example section for how to look up the coding.
}
\examples{
# Libraries required for the following two examples
library(dplyr)
library(purrr)

# Look up the tum_wwk_long species codes for all supported species
# the column species_id contains the tum_wwk_long codes
species_codings |>
  filter(species_coding == "tum_wwk_long") |>
  pluck(2, 1) |>
  arrange(as.numeric(species_id)) |> # just for the look of it
  print(n = Inf)

# Display a summary table which shows the number of single species behind
# each tum_wwk_long species code
species_codings |>
  filter(species_coding == "tum_wwk_long") |>
  pluck(2, 1) |>
  group_by(name_eng, species_id) |> # display english names
  summarise(n = n()) |>
  arrange(as.numeric(species_id)) |> # just for the look of it
  print(n = Inf)


# Make an fe_species_tum_wwk_long vector from a vector of integer codes
spec_ids <- fe_species_tum_wwk_long(
  c(10, 10, 10, 20, 20, 20, 50, 50, 811, 811, 811, 891)
)

}
