% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculateFuzzyMeasures.R
\name{CalculateFuzzyMeasures}
\alias{CalculateFuzzyMeasures}
\title{Calculation of the fuzzy measures for the imputed values.}
\usage{
CalculateFuzzyMeasures(
  trueData,
  imputedData,
  imputedMask,
  trapezoidal = TRUE,
  ...
)
}
\arguments{
\item{trueData}{Name of the input matrix (or data frame) with the true values of the variables.}

\item{imputedData}{Name of the input matrix (or data frame) with the imputed values.}

\item{imputedMask}{Matrix (or data frame) with logical values where \code{TRUE} indicates the cells with the imputed values.}

\item{trapezoidal}{Logical value depending on the type of fuzzy values (triangular or trapezoidal ones) in the dataset.}

\item{...}{Additional parameters passed to other functions.}
}
\value{
The output is given as a matrix (the rows are related to various types of the errors, the columns - to the variables and the overall mean).
}
\description{
`CalculateFuzzyMeasures` calculates the various types of fuzzy measures between two datasets -- the true and the imputed one.
}
\details{
The procedure calculates different types of the distance measures (Euclidean - the Euclidean measure,
AHD - the AHD measure, HSD - the HSD measure)
between two datasets - the first one with true values (set by \code{trueData}), and the second one (specified by \code{imputedData}) with
the imputed variables.
Only the truly imputed values are taken into account for these calculations.
To properly distinguish the real values with their imputed counterparts, the additional matrix \code{imputedMask} should be provided.
In this matrix, the logical value \code{TRUE} points out the cells with the imputed values.
Otherwise, \code{FALSE} should be used.

All of the input datasets can be given as matrices or data frames.
}
\examples{

# seed PRNG

set.seed(1234)

# load the necessary library

library(FuzzySimRes)

# generate sample of trapezoidal fuzzy numbers with FuzzySimRes library

list1<-SimulateSample(20,originalPD="rnorm",parOriginalPD=list(mean=0,sd=1),
incrCorePD="rexp", parIncrCorePD=list(rate=2),
suppLeftPD="runif",parSuppLeftPD=list(min=0,max=0.6),
suppRightPD="runif", parSuppRightPD=list(min=0,max=0.6),
type="trapezoidal")

# convert fuzzy data into a matrix

matrix1 <- FuzzyNumbersToMatrix(list1$value)

# check starting values

head(matrix1)

# add some NAs to the matrix

matrix1NA <- IntroducingNA(matrix1,percentage = 0.1)

head(matrix1NA)

# impute missing values

matrix1DImp <- ImputationDimp(matrix1NA)

# find cells with NAs

matrix1Mask <- is.na(matrix1NA)

# calculate fuzzy measures for the imputed values

CalculateFuzzyMeasures(matrix1,matrix1DImp,matrix1Mask,trapezoidal=TRUE)



}
