# Function returns correct values

    Code
      set.seed(123456)
      MethodsComparison(trueData = testMatrix1, iterations = 2, percentage = 0.1,
        verbose = FALSE)
    Output
      $dimp
      $dimp$nonFNNumbers
        V1 mean   se 
         1    1    0 
      
      $dimp$errorMatrix
                    X1        X2         X3         X4      mean         se
      MAE   0.21687283 0.4455456  1.5069736 0.11167709 0.5702673 0.02776636
      WMAE  0.17612711 0.4779174  3.4849887 0.14775710 1.0716976 0.02729339
      MSE   0.05816671 0.2380223  2.4355928 0.01317920 0.6862402 0.04014107
      WMSE  0.04598928 0.4289299 12.4882316 0.02554648 3.2471743 0.31572934
      NRMSE 0.10453666 0.1977038  0.7580186 0.05691153 0.2792926 0.01324942
      
      $dimp$statisticalMeasures
                                  X1          X2          X3           X4        mean
      TrueMean           -1.84384513  0.69917228  0.43100904 -0.296921806 -0.25264640
      ImpMean            -1.62697229  0.37675460 -0.13790493 -0.354425112 -0.43563693
      AbsDiffTrueImpMean  0.21687283  0.32241768  0.96631574  0.066162238  0.39294212
      GenMean            -0.89286341 -0.63303381  0.30935695  0.578825655 -0.15942865
      GenImpMean         -0.87117613 -0.66527557  0.25246555  0.573075324 -0.17772771
      AbsDiffGenImpMean   0.02168728  0.03224177  0.09663157  0.006616224  0.03929421
      TrueSD              1.11887185  2.00261989  0.10230236  0.878152324  1.02548661
      ImpSD               0.98051631  1.91771336  1.27692222  0.925703535  1.27521385
      AbsDiffTrueImpSD    0.13835554  0.32635020  1.17461986  0.093429820  0.43318886
      GenSD               1.23204855  1.22736828  1.02518086  1.020631251  1.12630723
      GenImpSD            1.21265939  1.18993314  1.12706609  1.023431295  1.13827248
      AbsDiffGenImpSD     0.01938916  0.03743514  0.10188524  0.002800044  0.04037739
                                   se
      TrueMean           0.0602434974
      ImpMean            0.2985856137
      AbsDiffTrueImpMean 0.1531541674
      GenMean            0.0000000000
      GenImpMean         0.0238342116
      AbsDiffGenImpMean  0.0153154167
      TrueSD             0.1354834486
      ImpSD              0.0174084628
      AbsDiffTrueImpSD   0.1882334272
      GenSD              0.0000000000
      GenImpSD           0.0053251546
      AbsDiffGenImpSD    0.0008473573
      
      $dimp$statisticalTests
                              V1      mean          se
      true+avs-anti    0.6648567 0.6648567 0.049150012
      true+ms-anti     0.6951272 0.6951272 0.023740407
      true+res-anti    0.6338028 0.6338028 0.012827193
      imputed+avs-anti 0.4051758 0.4051758 0.020699026
      imputed+ms-anti  0.4708985 0.4708985 0.003987103
      imputed+res-anti 0.5133078 0.5133078 0.028808994
      parts+avs-anti   0.8134615 0.8134615 0.023446606
      parts+ms-anti    0.7727174 0.7727174 0.023072861
      parts+res-anti   0.7935622 0.7935622 0.044508444
      
      $dimp$fuzzyMeasures
                        V1      mean         se
      Euclidean  0.0923471 0.0923471 0.03977684
      AHD        0.4642569 0.4642569 0.13576607
      HSD        0.3363756 0.3363756 0.10523932
      Bertoluzza 0.1670894 0.1670894 0.03828474
      DiffVal    0.1511283 0.1511283 0.03893445
      DiffAmb    0.1536623 0.1536623 0.04072627
      DiffEV     0.1240803 0.1240803 0.02783903
      DiffWidth  0.1278813 0.1278813 0.03052675
      
      
      $missForest
      $missForest$nonFNNumbers
             V1      mean        se 
      1.5000000 1.5000000 0.3535534 
      
      $missForest$errorMatrix
                    X1        X2        X3        X4      mean         se
      MAE   0.50507402 0.7745481 0.4661655 0.4998938 0.5614203 0.11236049
      WMAE  0.23268231 0.4723440 1.1051971 0.6446895 0.6137282 0.09152441
      MSE   0.59191386 0.9120216 0.2847556 0.2615484 0.5125598 0.14283866
      WMSE  0.06969094 0.2519201 1.6630945 0.4519573 0.6091657 0.21432778
      NRMSE 0.27663479 0.4110781 0.2304459 0.2533059 0.2928662 0.05921619
      
      $missForest$statisticalMeasures
                                  X1          X2          X3          X4        mean
      TrueMean           -1.84384513  0.69917228 0.431009040 -0.29692181 -0.25264640
      ImpMean            -1.33877111  0.01729868 0.032249638  0.20297197 -0.27156270
      AbsDiffTrueImpMean  0.50507402  0.68187360 0.398759402  0.49989378  0.52140020
      GenMean            -0.89286341 -0.63303381 0.309356951  0.57882565 -0.15942865
      GenImpMean         -0.84235601 -0.70122116 0.269481010  0.62881503 -0.16132028
      AbsDiffGenImpMean   0.05050740  0.06818736 0.039875940  0.04998938  0.05214002
      TrueSD              1.11887185  2.00261989 0.102302356  0.87815232  1.02548661
      ImpSD               0.59712615  1.08317029 0.290814740  0.76258536  0.68342413
      AbsDiffTrueImpSD    0.52174570  0.91944960 0.188512384  0.11556697  0.43631866
      GenSD               1.23204855  1.22736828 1.025180858  1.02063125  1.12630723
      GenImpSD            1.15842649  1.10005336 1.032690503  0.98259730  1.06844191
      AbsDiffGenImpSD     0.07362206  0.12731492 0.007509645  0.03803395  0.06162014
                                   se
      TrueMean           0.0602434974
      ImpMean            0.0633117440
      AbsDiffTrueImpMean 0.1406590026
      GenMean            0.0000000000
      GenImpMean         0.0003068247
      AbsDiffGenImpMean  0.0140659003
      TrueSD             0.1354834486
      ImpSD              0.0619656486
      AbsDiffTrueImpSD   0.0324715319
      GenSD              0.0000000000
      GenImpSD           0.0087107707
      AbsDiffGenImpSD    0.0104167749
      
      $missForest$statisticalTests
                              V1      mean         se
      true+avs-anti    0.6648567 0.6648567 0.04915001
      true+ms-anti     0.6471081 0.6471081 0.01003962
      true+res-anti    0.6968659 0.6968659 0.06565287
      imputed+avs-anti 0.4980012 0.4980012 0.08212652
      imputed+ms-anti  0.5254567 0.5254567 0.07616974
      imputed+res-anti 0.5113635 0.5113635 0.06375165
      parts+avs-anti   0.6872766 0.6872766 0.03421529
      parts+ms-anti    0.7358638 0.7358638 0.03280561
      parts+res-anti   0.7495245 0.7495245 0.02916225
      
      $missForest$fuzzyMeasures
                         V1       mean         se
      Euclidean  0.02909747 0.02909747 0.01045791
      AHD        0.32618412 0.32618412 0.07636216
      HSD        0.23605253 0.23605253 0.05929187
      Bertoluzza 0.12017545 0.12017545 0.02276038
      DiffVal    0.09546725 0.09546725 0.02602419
      DiffAmb    0.09546725 0.09546725 0.02602419
      DiffEV     0.09013159 0.09013159 0.01707029
      DiffWidth  0.09013159 0.09013159 0.01707029
      
      
      $miceRanger
      $miceRanger$nonFNNumbers
        V1 mean   se 
         2    2    0 
      
      $miceRanger$errorMatrix
                   X1        X2        X3        X4      mean         se
      MAE   0.6727459 1.0245715 0.6797585 0.5344831 0.7278897 0.07770300
      WMAE  0.2763539 0.5786063 1.6365744 0.7454369 0.8092429 0.01545126
      MSE   0.9923483 1.7350588 0.5493717 0.3697497 0.9116321 0.18797263
      WMSE  0.1211555 0.4239973 3.2913576 0.7501604 1.1466677 0.05855361
      NRMSE 0.4045132 0.5667099 0.3542184 0.3034581 0.4072249 0.04706119
      
      $miceRanger$statisticalMeasures
                                  X1          X2          X3          X4       mean
      TrueMean           -1.84384513  0.69917228  0.43100904 -0.29692181 -0.2526464
      ImpMean            -1.19344588 -0.22614784 -0.16389948  0.19642224 -0.3467677
      AbsDiffTrueImpMean  0.65039925  0.92532013  0.59490851  0.49334405  0.6659930
      GenMean            -0.89286341 -0.63303381  0.30935695  0.57882565 -0.1594287
      GenImpMean         -0.82782349 -0.72556582  0.24986610  0.62816006 -0.1688408
      AbsDiffGenImpMean   0.06503992  0.09253201  0.05949085  0.04933440  0.0665993
      TrueSD              1.11887185  2.00261989  0.10230236  0.87815232  1.0254866
      ImpSD               0.19818099  0.69401962  0.43518146  0.51363820  0.4602551
      AbsDiffTrueImpSD    0.92069086  1.30860027  0.37098615  0.36451412  0.7411978
      GenSD               1.23204855  1.22736828  1.02518086  1.02063125  1.1263072
      GenImpSD            1.14661517  1.06882900  1.04305734  0.96325080  1.0554381
      AbsDiffGenImpSD     0.08543339  0.15853928  0.01787649  0.05738045  0.0798074
                                  se
      TrueMean           0.060243497
      ImpMean            0.096286948
      AbsDiffTrueImpMean 0.106925769
      GenMean            0.000000000
      GenImpMean         0.003604345
      AbsDiffGenImpMean  0.010692577
      TrueSD             0.135483449
      ImpSD              0.033414792
      AbsDiffTrueImpSD   0.044471268
      GenSD              0.000000000
      GenImpSD           0.012182574
      AbsDiffGenImpSD    0.012698439
      
      $miceRanger$statisticalTests
                              V1      mean          se
      true+avs-anti    0.6416369 0.6416369 0.032731124
      true+ms-anti     0.6421789 0.6421789 0.020538654
      true+res-anti    0.6892184 0.6892184 0.013584876
      imputed+avs-anti 0.5410741 0.5410741 0.051669379
      imputed+ms-anti  0.6093115 0.6093115 0.001495358
      imputed+res-anti 0.6317906 0.6317906 0.005785142
      parts+avs-anti   0.7460179 0.7460179 0.075751630
      parts+ms-anti    0.7608318 0.7608318 0.056067489
      parts+res-anti   0.7665546 0.7665546 0.025919400
      
      $miceRanger$fuzzyMeasures
                         V1       mean           se
      Euclidean  0.04551652 0.04551652 0.0039938825
      AHD        0.39789921 0.39789921 0.0123137117
      HSD        0.29657779 0.29657779 0.0115567946
      Bertoluzza 0.13509523 0.13509523 0.0010092228
      DiffVal    0.11616517 0.11616517 0.0114316359
      DiffAmb    0.11616517 0.11616517 0.0114316359
      DiffEV     0.10132142 0.10132142 0.0007569171
      DiffWidth  0.10132142 0.10132142 0.0007569171
      
      
      $knn
      $knn$nonFNNumbers
             V1      mean        se 
      3.0000000 3.0000000 0.7071068 
      
      $knn$errorMatrix
                   X1        X2        X3        X4      mean         se
      MAE   0.8547951 1.1441775 0.3968067 0.7352770 0.7827641 0.12891038
      WMAE  0.3459249 0.7204759 0.9205403 0.9315421 0.7296208 0.05348817
      MSE   1.4906995 1.9690315 0.2112630 0.7795371 1.1126328 0.30243477
      WMSE  0.1592601 0.6002915 1.0899603 1.1262724 0.7439461 0.06337808
      NRMSE 0.4680417 0.6014376 0.2144926 0.4407309 0.4311757 0.06509935
      
      $knn$statisticalMeasures
                                  X1         X2          X3          X4        mean
      TrueMean           -1.84384513  0.6991723 0.431009040 -0.29692181 -0.25264640
      ImpMean            -1.01139663 -0.3457538 0.048838800  0.39721612 -0.22777388
      AbsDiffTrueImpMean  0.83244850  1.0449261 0.382170240  0.69413793  0.73842069
      GenMean            -0.89286341 -0.6330338 0.309356951  0.57882565 -0.15942865
      GenImpMean         -0.80961857 -0.7375264 0.271139926  0.64823945 -0.15694140
      AbsDiffGenImpMean   0.08324485  0.1044926 0.038217024  0.06941379  0.07384207
      TrueSD              1.11887185  2.0026199 0.102302356  0.87815232  1.02548661
      ImpSD               0.18990961  0.7354049 0.188058287  0.35105450  0.36610682
      AbsDiffTrueImpSD    0.92896224  1.2672150 0.248056269  0.52709783  0.74283283
      GenSD               1.23204855  1.2273683 1.025180858  1.02063125  1.12630723
      GenImpSD            1.13165558  1.0666061 1.029259536  0.94988996  1.04435278
      AbsDiffGenImpSD     0.10039297  0.1607622 0.004078677  0.07074129  0.08399379
                                   se
      TrueMean           0.0602434974
      ImpMean            0.0674292605
      AbsDiffTrueImpMean 0.1457210333
      GenMean            0.0000000000
      GenImpMean         0.0007185763
      AbsDiffGenImpMean  0.0145721033
      TrueSD             0.1354834486
      ImpSD              0.0296128972
      AbsDiffTrueImpSD   0.1060861283
      GenSD              0.0000000000
      GenImpSD           0.0146718182
      AbsDiffGenImpSD    0.0147450974
      
      $knn$statisticalTests
                              V1      mean         se
      true+avs-anti    0.6648567 0.6648567 0.04915001
      true+ms-anti     0.6699425 0.6699425 0.03394186
      true+res-anti    0.6852960 0.6852960 0.02190072
      imputed+avs-anti 0.6000727 0.6000727 0.09338769
      imputed+ms-anti  0.6500778 0.6500778 0.02820403
      imputed+res-anti 0.6636806 0.6636806 0.04330884
      parts+avs-anti   0.7419414 0.7419414 0.02965704
      parts+ms-anti    0.8114100 0.8114100 0.01313569
      parts+res-anti   0.7823130 0.7823130 0.01766331
      
      $knn$fuzzyMeasures
                         V1       mean           se
      Euclidean  0.04448320 0.04448320 0.0057280490
      AHD        0.39392195 0.39392195 0.0239778778
      HSD        0.29471326 0.29471326 0.0235701802
      Bertoluzza 0.13227825 0.13227825 0.0005435969
      DiffVal    0.10642905 0.10642905 0.0155895527
      DiffAmb    0.10642905 0.10642905 0.0155895527
      DiffEV     0.09920869 0.09920869 0.0004076977
      DiffWidth  0.09920869 0.09920869 0.0004076977
      
      
      $pmm
      $pmm$nonFNNumbers
        V1 mean   se 
         2    2    0 
      
      $pmm$errorMatrix
                   X1        X2        X3        X4      mean         se
      MAE   0.4764572 0.8220474 0.3658411 0.3344145 0.4996900 0.06161628
      WMAE  0.2220853 0.4846516 0.7679275 0.4465536 0.4803045 0.04896568
      MSE   0.4244940 1.1768928 0.2462377 0.2241885 0.5179532 0.15166913
      WMSE  0.0777500 0.3004821 0.9442980 0.3520208 0.4186377 0.12277469
      NRMSE 0.2826356 0.4436594 0.1886923 0.1911340 0.2765303 0.03570591
      
      $pmm$statisticalMeasures
                                  X1          X2          X3          X4        mean
      TrueMean           -1.84384513  0.69917228 0.431009040 -0.29692181 -0.25264640
      ImpMean            -1.38973455 -0.01886455 0.065167915 -0.04044042 -0.34596790
      AbsDiffTrueImpMean  0.45411058  0.71803683 0.365841125  0.33441451  0.46810076
      GenMean            -0.89286341 -0.63303381 0.309356951  0.57882565 -0.15942865
      GenImpMean         -0.84745236 -0.70483749 0.272772838  0.60447379 -0.16876080
      AbsDiffGenImpMean   0.04541106  0.07180368 0.036584113  0.03344145  0.04681008
      TrueSD              1.11887185  2.00261989 0.102302356  0.87815232  1.02548661
      ImpSD               0.47577510  0.98043203 0.082078480  0.69908273  0.55934208
      AbsDiffTrueImpSD    0.64309675  1.02218786 0.022080498  0.17906960  0.46660868
      GenSD               1.23204855  1.22736828 1.025180858  1.02063125  1.12630723
      GenImpSD            1.17200337  1.09709716 1.029429999  0.98671473  1.07131131
      AbsDiffGenImpSD     0.06004519  0.13027112 0.004643813  0.03391652  0.05721916
                                  se
      TrueMean           0.060243497
      ImpMean            0.215221897
      AbsDiffTrueImpMean 0.083953281
      GenMean            0.000000000
      GenImpMean         0.015497840
      AbsDiffGenImpMean  0.008395328
      TrueSD             0.135483449
      ImpSD              0.105849765
      AbsDiffTrueImpSD   0.029961892
      GenSD              0.000000000
      GenImpSD           0.007478559
      AbsDiffGenImpSD    0.009050626
      
      $pmm$statisticalTests
                              V1      mean          se
      true+avs-anti    0.6416369 0.6416369 0.032731124
      true+ms-anti     0.6941251 0.6941251 0.031857232
      true+res-anti    0.7613305 0.7613305 0.026758241
      imputed+avs-anti 0.5410741 0.5410741 0.051669379
      imputed+ms-anti  0.6063418 0.6063418 0.008704821
      imputed+res-anti 0.5723736 0.5723736 0.020283675
      parts+avs-anti   0.7113858 0.7113858 0.051263083
      parts+ms-anti    0.7609076 0.7609076 0.031586595
      parts+res-anti   0.7660329 0.7660329 0.042121085
      
      $pmm$fuzzyMeasures
                         V1       mean          se
      Euclidean  0.03021111 0.03021111 0.003034874
      AHD        0.28464482 0.28464482 0.038273583
      HSD        0.20907359 0.20907359 0.031447999
      Bertoluzza 0.10076163 0.10076163 0.009100779
      DiffVal    0.08055797 0.08055797 0.018905072
      DiffAmb    0.08055797 0.08055797 0.018905072
      DiffEV     0.07557122 0.07557122 0.006825584
      DiffWidth  0.07557122 0.07557122 0.006825584
      
      
      attr(,"class")
      [1] "metComp"

---

    Code
      set.seed(123456)
      MethodsComparison(trueData = testDF1, iterations = 2, percentage = 0.1,
        verbose = FALSE)
    Output
      $dimp
      $dimp$nonFNNumbers
        V1 mean   se 
         1    1    0 
      
      $dimp$errorMatrix
                    V1        V2         V3         V4      mean         se
      MAE   0.21687283 0.4455456  1.5069736 0.11167709 0.5702673 0.02776636
      WMAE  0.17612711 0.4779174  3.4849887 0.14775710 1.0716976 0.02729339
      MSE   0.05816671 0.2380223  2.4355928 0.01317920 0.6862402 0.04014107
      WMSE  0.04598928 0.4289299 12.4882316 0.02554648 3.2471743 0.31572934
      NRMSE 0.10453666 0.1977038  0.7580186 0.05691153 0.2792926 0.01324942
      
      $dimp$statisticalMeasures
                                  V1          V2          V3           V4        mean
      TrueMean           -1.84384513  0.69917228  0.43100904 -0.296921806 -0.25264640
      ImpMean            -1.62697229  0.37675460 -0.13790493 -0.354425112 -0.43563693
      AbsDiffTrueImpMean  0.21687283  0.32241768  0.96631574  0.066162238  0.39294212
      GenMean            -0.89286341 -0.63303381  0.30935695  0.578825655 -0.15942865
      GenImpMean         -0.87117613 -0.66527557  0.25246555  0.573075324 -0.17772771
      AbsDiffGenImpMean   0.02168728  0.03224177  0.09663157  0.006616224  0.03929421
      TrueSD              1.11887185  2.00261989  0.10230236  0.878152324  1.02548661
      ImpSD               0.98051631  1.91771336  1.27692222  0.925703535  1.27521385
      AbsDiffTrueImpSD    0.13835554  0.32635020  1.17461986  0.093429820  0.43318886
      GenSD               1.23204855  1.22736828  1.02518086  1.020631251  1.12630723
      GenImpSD            1.21265939  1.18993314  1.12706609  1.023431295  1.13827248
      AbsDiffGenImpSD     0.01938916  0.03743514  0.10188524  0.002800044  0.04037739
                                   se
      TrueMean           0.0602434974
      ImpMean            0.2985856137
      AbsDiffTrueImpMean 0.1531541674
      GenMean            0.0000000000
      GenImpMean         0.0238342116
      AbsDiffGenImpMean  0.0153154167
      TrueSD             0.1354834486
      ImpSD              0.0174084628
      AbsDiffTrueImpSD   0.1882334272
      GenSD              0.0000000000
      GenImpSD           0.0053251546
      AbsDiffGenImpSD    0.0008473573
      
      $dimp$statisticalTests
                              V1      mean          se
      true+avs-anti    0.6648567 0.6648567 0.049150012
      true+ms-anti     0.6951272 0.6951272 0.023740407
      true+res-anti    0.6338028 0.6338028 0.012827193
      imputed+avs-anti 0.4051758 0.4051758 0.020699026
      imputed+ms-anti  0.4708985 0.4708985 0.003987103
      imputed+res-anti 0.5133078 0.5133078 0.028808994
      parts+avs-anti   0.8134615 0.8134615 0.023446606
      parts+ms-anti    0.7727174 0.7727174 0.023072861
      parts+res-anti   0.7935622 0.7935622 0.044508444
      
      $dimp$fuzzyMeasures
                        V1      mean         se
      Euclidean  0.0923471 0.0923471 0.03977684
      AHD        0.4642569 0.4642569 0.13576607
      HSD        0.3363756 0.3363756 0.10523932
      Bertoluzza 0.1670894 0.1670894 0.03828474
      DiffVal    0.1511283 0.1511283 0.03893445
      DiffAmb    0.1536623 0.1536623 0.04072627
      DiffEV     0.1240803 0.1240803 0.02783903
      DiffWidth  0.1278813 0.1278813 0.03052675
      
      
      $missForest
      $missForest$nonFNNumbers
             V1      mean        se 
      1.5000000 1.5000000 0.3535534 
      
      $missForest$errorMatrix
                    V1        V2        V3        V4      mean         se
      MAE   0.50507402 0.7745481 0.4661655 0.4998938 0.5614203 0.11236049
      WMAE  0.23268231 0.4723440 1.1051971 0.6446895 0.6137282 0.09152441
      MSE   0.59191386 0.9120216 0.2847556 0.2615484 0.5125598 0.14283866
      WMSE  0.06969094 0.2519201 1.6630945 0.4519573 0.6091657 0.21432778
      NRMSE 0.27663479 0.4110781 0.2304459 0.2533059 0.2928662 0.05921619
      
      $missForest$statisticalMeasures
                                  V1          V2          V3          V4        mean
      TrueMean           -1.84384513  0.69917228 0.431009040 -0.29692181 -0.25264640
      ImpMean            -1.33877111  0.01729868 0.032249638  0.20297197 -0.27156270
      AbsDiffTrueImpMean  0.50507402  0.68187360 0.398759402  0.49989378  0.52140020
      GenMean            -0.89286341 -0.63303381 0.309356951  0.57882565 -0.15942865
      GenImpMean         -0.84235601 -0.70122116 0.269481010  0.62881503 -0.16132028
      AbsDiffGenImpMean   0.05050740  0.06818736 0.039875940  0.04998938  0.05214002
      TrueSD              1.11887185  2.00261989 0.102302356  0.87815232  1.02548661
      ImpSD               0.59712615  1.08317029 0.290814740  0.76258536  0.68342413
      AbsDiffTrueImpSD    0.52174570  0.91944960 0.188512384  0.11556697  0.43631866
      GenSD               1.23204855  1.22736828 1.025180858  1.02063125  1.12630723
      GenImpSD            1.15842649  1.10005336 1.032690503  0.98259730  1.06844191
      AbsDiffGenImpSD     0.07362206  0.12731492 0.007509645  0.03803395  0.06162014
                                   se
      TrueMean           0.0602434974
      ImpMean            0.0633117440
      AbsDiffTrueImpMean 0.1406590026
      GenMean            0.0000000000
      GenImpMean         0.0003068247
      AbsDiffGenImpMean  0.0140659003
      TrueSD             0.1354834486
      ImpSD              0.0619656486
      AbsDiffTrueImpSD   0.0324715319
      GenSD              0.0000000000
      GenImpSD           0.0087107707
      AbsDiffGenImpSD    0.0104167749
      
      $missForest$statisticalTests
                              V1      mean         se
      true+avs-anti    0.6648567 0.6648567 0.04915001
      true+ms-anti     0.6471081 0.6471081 0.01003962
      true+res-anti    0.6968659 0.6968659 0.06565287
      imputed+avs-anti 0.4980012 0.4980012 0.08212652
      imputed+ms-anti  0.5254567 0.5254567 0.07616974
      imputed+res-anti 0.5113635 0.5113635 0.06375165
      parts+avs-anti   0.6872766 0.6872766 0.03421529
      parts+ms-anti    0.7358638 0.7358638 0.03280561
      parts+res-anti   0.7495245 0.7495245 0.02916225
      
      $missForest$fuzzyMeasures
                         V1       mean         se
      Euclidean  0.02909747 0.02909747 0.01045791
      AHD        0.32618412 0.32618412 0.07636216
      HSD        0.23605253 0.23605253 0.05929187
      Bertoluzza 0.12017545 0.12017545 0.02276038
      DiffVal    0.09546725 0.09546725 0.02602419
      DiffAmb    0.09546725 0.09546725 0.02602419
      DiffEV     0.09013159 0.09013159 0.01707029
      DiffWidth  0.09013159 0.09013159 0.01707029
      
      
      $miceRanger
      $miceRanger$nonFNNumbers
        V1 mean   se 
         2    2    0 
      
      $miceRanger$errorMatrix
                   V1        V2        V3        V4      mean         se
      MAE   0.6727459 1.0245715 0.6797585 0.5344831 0.7278897 0.07770300
      WMAE  0.2763539 0.5786063 1.6365744 0.7454369 0.8092429 0.01545126
      MSE   0.9923483 1.7350588 0.5493717 0.3697497 0.9116321 0.18797263
      WMSE  0.1211555 0.4239973 3.2913576 0.7501604 1.1466677 0.05855361
      NRMSE 0.4045132 0.5667099 0.3542184 0.3034581 0.4072249 0.04706119
      
      $miceRanger$statisticalMeasures
                                  V1          V2          V3          V4       mean
      TrueMean           -1.84384513  0.69917228  0.43100904 -0.29692181 -0.2526464
      ImpMean            -1.19344588 -0.22614784 -0.16389948  0.19642224 -0.3467677
      AbsDiffTrueImpMean  0.65039925  0.92532013  0.59490851  0.49334405  0.6659930
      GenMean            -0.89286341 -0.63303381  0.30935695  0.57882565 -0.1594287
      GenImpMean         -0.82782349 -0.72556582  0.24986610  0.62816006 -0.1688408
      AbsDiffGenImpMean   0.06503992  0.09253201  0.05949085  0.04933440  0.0665993
      TrueSD              1.11887185  2.00261989  0.10230236  0.87815232  1.0254866
      ImpSD               0.19818099  0.69401962  0.43518146  0.51363820  0.4602551
      AbsDiffTrueImpSD    0.92069086  1.30860027  0.37098615  0.36451412  0.7411978
      GenSD               1.23204855  1.22736828  1.02518086  1.02063125  1.1263072
      GenImpSD            1.14661517  1.06882900  1.04305734  0.96325080  1.0554381
      AbsDiffGenImpSD     0.08543339  0.15853928  0.01787649  0.05738045  0.0798074
                                  se
      TrueMean           0.060243497
      ImpMean            0.096286948
      AbsDiffTrueImpMean 0.106925769
      GenMean            0.000000000
      GenImpMean         0.003604345
      AbsDiffGenImpMean  0.010692577
      TrueSD             0.135483449
      ImpSD              0.033414792
      AbsDiffTrueImpSD   0.044471268
      GenSD              0.000000000
      GenImpSD           0.012182574
      AbsDiffGenImpSD    0.012698439
      
      $miceRanger$statisticalTests
                              V1      mean          se
      true+avs-anti    0.6416369 0.6416369 0.032731124
      true+ms-anti     0.6421789 0.6421789 0.020538654
      true+res-anti    0.6892184 0.6892184 0.013584876
      imputed+avs-anti 0.5410741 0.5410741 0.051669379
      imputed+ms-anti  0.6093115 0.6093115 0.001495358
      imputed+res-anti 0.6317906 0.6317906 0.005785142
      parts+avs-anti   0.7460179 0.7460179 0.075751630
      parts+ms-anti    0.7608318 0.7608318 0.056067489
      parts+res-anti   0.7665546 0.7665546 0.025919400
      
      $miceRanger$fuzzyMeasures
                         V1       mean           se
      Euclidean  0.04551652 0.04551652 0.0039938825
      AHD        0.39789921 0.39789921 0.0123137117
      HSD        0.29657779 0.29657779 0.0115567946
      Bertoluzza 0.13509523 0.13509523 0.0010092228
      DiffVal    0.11616517 0.11616517 0.0114316359
      DiffAmb    0.11616517 0.11616517 0.0114316359
      DiffEV     0.10132142 0.10132142 0.0007569171
      DiffWidth  0.10132142 0.10132142 0.0007569171
      
      
      $knn
      $knn$nonFNNumbers
             V1      mean        se 
      3.0000000 3.0000000 0.7071068 
      
      $knn$errorMatrix
                   V1        V2        V3        V4      mean         se
      MAE   0.8547951 1.1441775 0.3968067 0.7352770 0.7827641 0.12891038
      WMAE  0.3459249 0.7204759 0.9205403 0.9315421 0.7296208 0.05348817
      MSE   1.4906995 1.9690315 0.2112630 0.7795371 1.1126328 0.30243477
      WMSE  0.1592601 0.6002915 1.0899603 1.1262724 0.7439461 0.06337808
      NRMSE 0.4680417 0.6014376 0.2144926 0.4407309 0.4311757 0.06509935
      
      $knn$statisticalMeasures
                                  V1         V2          V3          V4        mean
      TrueMean           -1.84384513  0.6991723 0.431009040 -0.29692181 -0.25264640
      ImpMean            -1.01139663 -0.3457538 0.048838800  0.39721612 -0.22777388
      AbsDiffTrueImpMean  0.83244850  1.0449261 0.382170240  0.69413793  0.73842069
      GenMean            -0.89286341 -0.6330338 0.309356951  0.57882565 -0.15942865
      GenImpMean         -0.80961857 -0.7375264 0.271139926  0.64823945 -0.15694140
      AbsDiffGenImpMean   0.08324485  0.1044926 0.038217024  0.06941379  0.07384207
      TrueSD              1.11887185  2.0026199 0.102302356  0.87815232  1.02548661
      ImpSD               0.18990961  0.7354049 0.188058287  0.35105450  0.36610682
      AbsDiffTrueImpSD    0.92896224  1.2672150 0.248056269  0.52709783  0.74283283
      GenSD               1.23204855  1.2273683 1.025180858  1.02063125  1.12630723
      GenImpSD            1.13165558  1.0666061 1.029259536  0.94988996  1.04435278
      AbsDiffGenImpSD     0.10039297  0.1607622 0.004078677  0.07074129  0.08399379
                                   se
      TrueMean           0.0602434974
      ImpMean            0.0674292605
      AbsDiffTrueImpMean 0.1457210333
      GenMean            0.0000000000
      GenImpMean         0.0007185763
      AbsDiffGenImpMean  0.0145721033
      TrueSD             0.1354834486
      ImpSD              0.0296128972
      AbsDiffTrueImpSD   0.1060861283
      GenSD              0.0000000000
      GenImpSD           0.0146718182
      AbsDiffGenImpSD    0.0147450974
      
      $knn$statisticalTests
                              V1      mean         se
      true+avs-anti    0.6648567 0.6648567 0.04915001
      true+ms-anti     0.6699425 0.6699425 0.03394186
      true+res-anti    0.6852960 0.6852960 0.02190072
      imputed+avs-anti 0.6000727 0.6000727 0.09338769
      imputed+ms-anti  0.6500778 0.6500778 0.02820403
      imputed+res-anti 0.6636806 0.6636806 0.04330884
      parts+avs-anti   0.7419414 0.7419414 0.02965704
      parts+ms-anti    0.8114100 0.8114100 0.01313569
      parts+res-anti   0.7823130 0.7823130 0.01766331
      
      $knn$fuzzyMeasures
                         V1       mean           se
      Euclidean  0.04448320 0.04448320 0.0057280490
      AHD        0.39392195 0.39392195 0.0239778778
      HSD        0.29471326 0.29471326 0.0235701802
      Bertoluzza 0.13227825 0.13227825 0.0005435969
      DiffVal    0.10642905 0.10642905 0.0155895527
      DiffAmb    0.10642905 0.10642905 0.0155895527
      DiffEV     0.09920869 0.09920869 0.0004076977
      DiffWidth  0.09920869 0.09920869 0.0004076977
      
      
      $pmm
      $pmm$nonFNNumbers
        V1 mean   se 
         2    2    0 
      
      $pmm$errorMatrix
                   V1        V2        V3        V4      mean         se
      MAE   0.4764572 0.8220474 0.3658411 0.3344145 0.4996900 0.06161628
      WMAE  0.2220853 0.4846516 0.7679275 0.4465536 0.4803045 0.04896568
      MSE   0.4244940 1.1768928 0.2462377 0.2241885 0.5179532 0.15166913
      WMSE  0.0777500 0.3004821 0.9442980 0.3520208 0.4186377 0.12277469
      NRMSE 0.2826356 0.4436594 0.1886923 0.1911340 0.2765303 0.03570591
      
      $pmm$statisticalMeasures
                                  V1          V2          V3          V4        mean
      TrueMean           -1.84384513  0.69917228 0.431009040 -0.29692181 -0.25264640
      ImpMean            -1.38973455 -0.01886455 0.065167915 -0.04044042 -0.34596790
      AbsDiffTrueImpMean  0.45411058  0.71803683 0.365841125  0.33441451  0.46810076
      GenMean            -0.89286341 -0.63303381 0.309356951  0.57882565 -0.15942865
      GenImpMean         -0.84745236 -0.70483749 0.272772838  0.60447379 -0.16876080
      AbsDiffGenImpMean   0.04541106  0.07180368 0.036584113  0.03344145  0.04681008
      TrueSD              1.11887185  2.00261989 0.102302356  0.87815232  1.02548661
      ImpSD               0.47577510  0.98043203 0.082078480  0.69908273  0.55934208
      AbsDiffTrueImpSD    0.64309675  1.02218786 0.022080498  0.17906960  0.46660868
      GenSD               1.23204855  1.22736828 1.025180858  1.02063125  1.12630723
      GenImpSD            1.17200337  1.09709716 1.029429999  0.98671473  1.07131131
      AbsDiffGenImpSD     0.06004519  0.13027112 0.004643813  0.03391652  0.05721916
                                  se
      TrueMean           0.060243497
      ImpMean            0.215221897
      AbsDiffTrueImpMean 0.083953281
      GenMean            0.000000000
      GenImpMean         0.015497840
      AbsDiffGenImpMean  0.008395328
      TrueSD             0.135483449
      ImpSD              0.105849765
      AbsDiffTrueImpSD   0.029961892
      GenSD              0.000000000
      GenImpSD           0.007478559
      AbsDiffGenImpSD    0.009050626
      
      $pmm$statisticalTests
                              V1      mean          se
      true+avs-anti    0.6416369 0.6416369 0.032731124
      true+ms-anti     0.6941251 0.6941251 0.031857232
      true+res-anti    0.7613305 0.7613305 0.026758241
      imputed+avs-anti 0.5410741 0.5410741 0.051669379
      imputed+ms-anti  0.6063418 0.6063418 0.008704821
      imputed+res-anti 0.5723736 0.5723736 0.020283675
      parts+avs-anti   0.7113858 0.7113858 0.051263083
      parts+ms-anti    0.7609076 0.7609076 0.031586595
      parts+res-anti   0.7660329 0.7660329 0.042121085
      
      $pmm$fuzzyMeasures
                         V1       mean          se
      Euclidean  0.03021111 0.03021111 0.003034874
      AHD        0.28464482 0.28464482 0.038273583
      HSD        0.20907359 0.20907359 0.031447999
      Bertoluzza 0.10076163 0.10076163 0.009100779
      DiffVal    0.08055797 0.08055797 0.018905072
      DiffAmb    0.08055797 0.08055797 0.018905072
      DiffEV     0.07557122 0.07557122 0.006825584
      DiffWidth  0.07557122 0.07557122 0.006825584
      
      
      attr(,"class")
      [1] "metComp"

---

    Code
      set.seed(123456)
      MethodsComparison(trueData = testList1, iterations = 2, percentage = 0.1,
        verbose = FALSE)
    Output
      $dimp
      $dimp$nonFNNumbers
        V1 mean   se 
         1    1    0 
      
      $dimp$errorMatrix
                    X1        X2         X3         X4      mean         se
      MAE   0.21687283 0.4455456  1.5069736 0.11167709 0.5702673 0.02776636
      WMAE  0.17612711 0.4779174  3.4849887 0.14775710 1.0716976 0.02729339
      MSE   0.05816671 0.2380223  2.4355928 0.01317920 0.6862402 0.04014107
      WMSE  0.04598928 0.4289299 12.4882316 0.02554648 3.2471743 0.31572934
      NRMSE 0.10453666 0.1977038  0.7580186 0.05691153 0.2792926 0.01324942
      
      $dimp$statisticalMeasures
                                  X1          X2          X3           X4        mean
      TrueMean           -1.84384513  0.69917228  0.43100904 -0.296921806 -0.25264640
      ImpMean            -1.62697229  0.37675460 -0.13790493 -0.354425112 -0.43563693
      AbsDiffTrueImpMean  0.21687283  0.32241768  0.96631574  0.066162238  0.39294212
      GenMean            -0.89286341 -0.63303381  0.30935695  0.578825655 -0.15942865
      GenImpMean         -0.87117613 -0.66527557  0.25246555  0.573075324 -0.17772771
      AbsDiffGenImpMean   0.02168728  0.03224177  0.09663157  0.006616224  0.03929421
      TrueSD              1.11887185  2.00261989  0.10230236  0.878152324  1.02548661
      ImpSD               0.98051631  1.91771336  1.27692222  0.925703535  1.27521385
      AbsDiffTrueImpSD    0.13835554  0.32635020  1.17461986  0.093429820  0.43318886
      GenSD               1.23204855  1.22736828  1.02518086  1.020631251  1.12630723
      GenImpSD            1.21265939  1.18993314  1.12706609  1.023431295  1.13827248
      AbsDiffGenImpSD     0.01938916  0.03743514  0.10188524  0.002800044  0.04037739
                                   se
      TrueMean           0.0602434974
      ImpMean            0.2985856137
      AbsDiffTrueImpMean 0.1531541674
      GenMean            0.0000000000
      GenImpMean         0.0238342116
      AbsDiffGenImpMean  0.0153154167
      TrueSD             0.1354834486
      ImpSD              0.0174084628
      AbsDiffTrueImpSD   0.1882334272
      GenSD              0.0000000000
      GenImpSD           0.0053251546
      AbsDiffGenImpSD    0.0008473573
      
      $dimp$statisticalTests
                              V1      mean          se
      true+avs-anti    0.6648567 0.6648567 0.049150012
      true+ms-anti     0.6951272 0.6951272 0.023740407
      true+res-anti    0.6338028 0.6338028 0.012827193
      imputed+avs-anti 0.4051758 0.4051758 0.020699026
      imputed+ms-anti  0.4708985 0.4708985 0.003987103
      imputed+res-anti 0.5133078 0.5133078 0.028808994
      parts+avs-anti   0.8134615 0.8134615 0.023446606
      parts+ms-anti    0.7727174 0.7727174 0.023072861
      parts+res-anti   0.7935622 0.7935622 0.044508444
      
      $dimp$fuzzyMeasures
                        V1      mean         se
      Euclidean  0.0923471 0.0923471 0.03977684
      AHD        0.4642569 0.4642569 0.13576607
      HSD        0.3363756 0.3363756 0.10523932
      Bertoluzza 0.1670894 0.1670894 0.03828474
      DiffVal    0.1511283 0.1511283 0.03893445
      DiffAmb    0.1536623 0.1536623 0.04072627
      DiffEV     0.1240803 0.1240803 0.02783903
      DiffWidth  0.1278813 0.1278813 0.03052675
      
      
      $missForest
      $missForest$nonFNNumbers
             V1      mean        se 
      1.5000000 1.5000000 0.3535534 
      
      $missForest$errorMatrix
                    X1        X2        X3        X4      mean         se
      MAE   0.50507402 0.7745481 0.4661655 0.4998938 0.5614203 0.11236049
      WMAE  0.23268231 0.4723440 1.1051971 0.6446895 0.6137282 0.09152441
      MSE   0.59191386 0.9120216 0.2847556 0.2615484 0.5125598 0.14283866
      WMSE  0.06969094 0.2519201 1.6630945 0.4519573 0.6091657 0.21432778
      NRMSE 0.27663479 0.4110781 0.2304459 0.2533059 0.2928662 0.05921619
      
      $missForest$statisticalMeasures
                                  X1          X2          X3          X4        mean
      TrueMean           -1.84384513  0.69917228 0.431009040 -0.29692181 -0.25264640
      ImpMean            -1.33877111  0.01729868 0.032249638  0.20297197 -0.27156270
      AbsDiffTrueImpMean  0.50507402  0.68187360 0.398759402  0.49989378  0.52140020
      GenMean            -0.89286341 -0.63303381 0.309356951  0.57882565 -0.15942865
      GenImpMean         -0.84235601 -0.70122116 0.269481010  0.62881503 -0.16132028
      AbsDiffGenImpMean   0.05050740  0.06818736 0.039875940  0.04998938  0.05214002
      TrueSD              1.11887185  2.00261989 0.102302356  0.87815232  1.02548661
      ImpSD               0.59712615  1.08317029 0.290814740  0.76258536  0.68342413
      AbsDiffTrueImpSD    0.52174570  0.91944960 0.188512384  0.11556697  0.43631866
      GenSD               1.23204855  1.22736828 1.025180858  1.02063125  1.12630723
      GenImpSD            1.15842649  1.10005336 1.032690503  0.98259730  1.06844191
      AbsDiffGenImpSD     0.07362206  0.12731492 0.007509645  0.03803395  0.06162014
                                   se
      TrueMean           0.0602434974
      ImpMean            0.0633117440
      AbsDiffTrueImpMean 0.1406590026
      GenMean            0.0000000000
      GenImpMean         0.0003068247
      AbsDiffGenImpMean  0.0140659003
      TrueSD             0.1354834486
      ImpSD              0.0619656486
      AbsDiffTrueImpSD   0.0324715319
      GenSD              0.0000000000
      GenImpSD           0.0087107707
      AbsDiffGenImpSD    0.0104167749
      
      $missForest$statisticalTests
                              V1      mean         se
      true+avs-anti    0.6648567 0.6648567 0.04915001
      true+ms-anti     0.6471081 0.6471081 0.01003962
      true+res-anti    0.6968659 0.6968659 0.06565287
      imputed+avs-anti 0.4980012 0.4980012 0.08212652
      imputed+ms-anti  0.5254567 0.5254567 0.07616974
      imputed+res-anti 0.5113635 0.5113635 0.06375165
      parts+avs-anti   0.6872766 0.6872766 0.03421529
      parts+ms-anti    0.7358638 0.7358638 0.03280561
      parts+res-anti   0.7495245 0.7495245 0.02916225
      
      $missForest$fuzzyMeasures
                         V1       mean         se
      Euclidean  0.02909747 0.02909747 0.01045791
      AHD        0.32618412 0.32618412 0.07636216
      HSD        0.23605253 0.23605253 0.05929187
      Bertoluzza 0.12017545 0.12017545 0.02276038
      DiffVal    0.09546725 0.09546725 0.02602419
      DiffAmb    0.09546725 0.09546725 0.02602419
      DiffEV     0.09013159 0.09013159 0.01707029
      DiffWidth  0.09013159 0.09013159 0.01707029
      
      
      $miceRanger
      $miceRanger$nonFNNumbers
        V1 mean   se 
         2    2    0 
      
      $miceRanger$errorMatrix
                   X1        X2        X3        X4      mean         se
      MAE   0.6727459 1.0245715 0.6797585 0.5344831 0.7278897 0.07770300
      WMAE  0.2763539 0.5786063 1.6365744 0.7454369 0.8092429 0.01545126
      MSE   0.9923483 1.7350588 0.5493717 0.3697497 0.9116321 0.18797263
      WMSE  0.1211555 0.4239973 3.2913576 0.7501604 1.1466677 0.05855361
      NRMSE 0.4045132 0.5667099 0.3542184 0.3034581 0.4072249 0.04706119
      
      $miceRanger$statisticalMeasures
                                  X1          X2          X3          X4       mean
      TrueMean           -1.84384513  0.69917228  0.43100904 -0.29692181 -0.2526464
      ImpMean            -1.19344588 -0.22614784 -0.16389948  0.19642224 -0.3467677
      AbsDiffTrueImpMean  0.65039925  0.92532013  0.59490851  0.49334405  0.6659930
      GenMean            -0.89286341 -0.63303381  0.30935695  0.57882565 -0.1594287
      GenImpMean         -0.82782349 -0.72556582  0.24986610  0.62816006 -0.1688408
      AbsDiffGenImpMean   0.06503992  0.09253201  0.05949085  0.04933440  0.0665993
      TrueSD              1.11887185  2.00261989  0.10230236  0.87815232  1.0254866
      ImpSD               0.19818099  0.69401962  0.43518146  0.51363820  0.4602551
      AbsDiffTrueImpSD    0.92069086  1.30860027  0.37098615  0.36451412  0.7411978
      GenSD               1.23204855  1.22736828  1.02518086  1.02063125  1.1263072
      GenImpSD            1.14661517  1.06882900  1.04305734  0.96325080  1.0554381
      AbsDiffGenImpSD     0.08543339  0.15853928  0.01787649  0.05738045  0.0798074
                                  se
      TrueMean           0.060243497
      ImpMean            0.096286948
      AbsDiffTrueImpMean 0.106925769
      GenMean            0.000000000
      GenImpMean         0.003604345
      AbsDiffGenImpMean  0.010692577
      TrueSD             0.135483449
      ImpSD              0.033414792
      AbsDiffTrueImpSD   0.044471268
      GenSD              0.000000000
      GenImpSD           0.012182574
      AbsDiffGenImpSD    0.012698439
      
      $miceRanger$statisticalTests
                              V1      mean          se
      true+avs-anti    0.6416369 0.6416369 0.032731124
      true+ms-anti     0.6421789 0.6421789 0.020538654
      true+res-anti    0.6892184 0.6892184 0.013584876
      imputed+avs-anti 0.5410741 0.5410741 0.051669379
      imputed+ms-anti  0.6093115 0.6093115 0.001495358
      imputed+res-anti 0.6317906 0.6317906 0.005785142
      parts+avs-anti   0.7460179 0.7460179 0.075751630
      parts+ms-anti    0.7608318 0.7608318 0.056067489
      parts+res-anti   0.7665546 0.7665546 0.025919400
      
      $miceRanger$fuzzyMeasures
                         V1       mean           se
      Euclidean  0.04551652 0.04551652 0.0039938825
      AHD        0.39789921 0.39789921 0.0123137117
      HSD        0.29657779 0.29657779 0.0115567946
      Bertoluzza 0.13509523 0.13509523 0.0010092228
      DiffVal    0.11616517 0.11616517 0.0114316359
      DiffAmb    0.11616517 0.11616517 0.0114316359
      DiffEV     0.10132142 0.10132142 0.0007569171
      DiffWidth  0.10132142 0.10132142 0.0007569171
      
      
      $knn
      $knn$nonFNNumbers
             V1      mean        se 
      3.0000000 3.0000000 0.7071068 
      
      $knn$errorMatrix
                   X1        X2        X3        X4      mean         se
      MAE   0.8547951 1.1441775 0.3968067 0.7352770 0.7827641 0.12891038
      WMAE  0.3459249 0.7204759 0.9205403 0.9315421 0.7296208 0.05348817
      MSE   1.4906995 1.9690315 0.2112630 0.7795371 1.1126328 0.30243477
      WMSE  0.1592601 0.6002915 1.0899603 1.1262724 0.7439461 0.06337808
      NRMSE 0.4680417 0.6014376 0.2144926 0.4407309 0.4311757 0.06509935
      
      $knn$statisticalMeasures
                                  X1         X2          X3          X4        mean
      TrueMean           -1.84384513  0.6991723 0.431009040 -0.29692181 -0.25264640
      ImpMean            -1.01139663 -0.3457538 0.048838800  0.39721612 -0.22777388
      AbsDiffTrueImpMean  0.83244850  1.0449261 0.382170240  0.69413793  0.73842069
      GenMean            -0.89286341 -0.6330338 0.309356951  0.57882565 -0.15942865
      GenImpMean         -0.80961857 -0.7375264 0.271139926  0.64823945 -0.15694140
      AbsDiffGenImpMean   0.08324485  0.1044926 0.038217024  0.06941379  0.07384207
      TrueSD              1.11887185  2.0026199 0.102302356  0.87815232  1.02548661
      ImpSD               0.18990961  0.7354049 0.188058287  0.35105450  0.36610682
      AbsDiffTrueImpSD    0.92896224  1.2672150 0.248056269  0.52709783  0.74283283
      GenSD               1.23204855  1.2273683 1.025180858  1.02063125  1.12630723
      GenImpSD            1.13165558  1.0666061 1.029259536  0.94988996  1.04435278
      AbsDiffGenImpSD     0.10039297  0.1607622 0.004078677  0.07074129  0.08399379
                                   se
      TrueMean           0.0602434974
      ImpMean            0.0674292605
      AbsDiffTrueImpMean 0.1457210333
      GenMean            0.0000000000
      GenImpMean         0.0007185763
      AbsDiffGenImpMean  0.0145721033
      TrueSD             0.1354834486
      ImpSD              0.0296128972
      AbsDiffTrueImpSD   0.1060861283
      GenSD              0.0000000000
      GenImpSD           0.0146718182
      AbsDiffGenImpSD    0.0147450974
      
      $knn$statisticalTests
                              V1      mean         se
      true+avs-anti    0.6648567 0.6648567 0.04915001
      true+ms-anti     0.6699425 0.6699425 0.03394186
      true+res-anti    0.6852960 0.6852960 0.02190072
      imputed+avs-anti 0.6000727 0.6000727 0.09338769
      imputed+ms-anti  0.6500778 0.6500778 0.02820403
      imputed+res-anti 0.6636806 0.6636806 0.04330884
      parts+avs-anti   0.7419414 0.7419414 0.02965704
      parts+ms-anti    0.8114100 0.8114100 0.01313569
      parts+res-anti   0.7823130 0.7823130 0.01766331
      
      $knn$fuzzyMeasures
                         V1       mean           se
      Euclidean  0.04448320 0.04448320 0.0057280490
      AHD        0.39392195 0.39392195 0.0239778778
      HSD        0.29471326 0.29471326 0.0235701802
      Bertoluzza 0.13227825 0.13227825 0.0005435969
      DiffVal    0.10642905 0.10642905 0.0155895527
      DiffAmb    0.10642905 0.10642905 0.0155895527
      DiffEV     0.09920869 0.09920869 0.0004076977
      DiffWidth  0.09920869 0.09920869 0.0004076977
      
      
      $pmm
      $pmm$nonFNNumbers
        V1 mean   se 
         2    2    0 
      
      $pmm$errorMatrix
                   X1        X2        X3        X4      mean         se
      MAE   0.4764572 0.8220474 0.3658411 0.3344145 0.4996900 0.06161628
      WMAE  0.2220853 0.4846516 0.7679275 0.4465536 0.4803045 0.04896568
      MSE   0.4244940 1.1768928 0.2462377 0.2241885 0.5179532 0.15166913
      WMSE  0.0777500 0.3004821 0.9442980 0.3520208 0.4186377 0.12277469
      NRMSE 0.2826356 0.4436594 0.1886923 0.1911340 0.2765303 0.03570591
      
      $pmm$statisticalMeasures
                                  X1          X2          X3          X4        mean
      TrueMean           -1.84384513  0.69917228 0.431009040 -0.29692181 -0.25264640
      ImpMean            -1.38973455 -0.01886455 0.065167915 -0.04044042 -0.34596790
      AbsDiffTrueImpMean  0.45411058  0.71803683 0.365841125  0.33441451  0.46810076
      GenMean            -0.89286341 -0.63303381 0.309356951  0.57882565 -0.15942865
      GenImpMean         -0.84745236 -0.70483749 0.272772838  0.60447379 -0.16876080
      AbsDiffGenImpMean   0.04541106  0.07180368 0.036584113  0.03344145  0.04681008
      TrueSD              1.11887185  2.00261989 0.102302356  0.87815232  1.02548661
      ImpSD               0.47577510  0.98043203 0.082078480  0.69908273  0.55934208
      AbsDiffTrueImpSD    0.64309675  1.02218786 0.022080498  0.17906960  0.46660868
      GenSD               1.23204855  1.22736828 1.025180858  1.02063125  1.12630723
      GenImpSD            1.17200337  1.09709716 1.029429999  0.98671473  1.07131131
      AbsDiffGenImpSD     0.06004519  0.13027112 0.004643813  0.03391652  0.05721916
                                  se
      TrueMean           0.060243497
      ImpMean            0.215221897
      AbsDiffTrueImpMean 0.083953281
      GenMean            0.000000000
      GenImpMean         0.015497840
      AbsDiffGenImpMean  0.008395328
      TrueSD             0.135483449
      ImpSD              0.105849765
      AbsDiffTrueImpSD   0.029961892
      GenSD              0.000000000
      GenImpSD           0.007478559
      AbsDiffGenImpSD    0.009050626
      
      $pmm$statisticalTests
                              V1      mean          se
      true+avs-anti    0.6416369 0.6416369 0.032731124
      true+ms-anti     0.6941251 0.6941251 0.031857232
      true+res-anti    0.7613305 0.7613305 0.026758241
      imputed+avs-anti 0.5410741 0.5410741 0.051669379
      imputed+ms-anti  0.6063418 0.6063418 0.008704821
      imputed+res-anti 0.5723736 0.5723736 0.020283675
      parts+avs-anti   0.7113858 0.7113858 0.051263083
      parts+ms-anti    0.7609076 0.7609076 0.031586595
      parts+res-anti   0.7660329 0.7660329 0.042121085
      
      $pmm$fuzzyMeasures
                         V1       mean          se
      Euclidean  0.03021111 0.03021111 0.003034874
      AHD        0.28464482 0.28464482 0.038273583
      HSD        0.20907359 0.20907359 0.031447999
      Bertoluzza 0.10076163 0.10076163 0.009100779
      DiffVal    0.08055797 0.08055797 0.018905072
      DiffAmb    0.08055797 0.08055797 0.018905072
      DiffEV     0.07557122 0.07557122 0.006825584
      DiffWidth  0.07557122 0.07557122 0.006825584
      
      
      attr(,"class")
      [1] "metComp"

