# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Fit a linear model via the GAGA algorithm using cpp.
#'
#' @param X Input matrix, of dimension nobs*nvars; each row is an observation.
#' If the intercept term needs to be considered in the estimation process, then the first column of \code{X} must be all 1s.
#' @param y Quantitative response N*1 matrix.
#' @param s_alpha Hyperparameter. The suggested value for alpha is 2 or 3.
#' @param s_itrNum The number of iteration steps. In general, 20 steps are enough.
#' @param s_thresh Convergence threshold for beta Change, if \code{max(abs(beta-beta_old))<threshold}, return.
#' @param s_QR_flag It identifies whether to use QR decomposition to speed up the algorithm.
#' @param s_flag It identifies whether to make model selection. The default is \code{TRUE}.
#' @param s_lamda_0 The initial value of the regularization parameter for ridge regression.
#' @param s_fix_sigma It identifies whether to update the variance estimate of the Gaussian noise or not.
#' @param s_sigm2_0 The initial variance of the Gaussian noise.
#' @param s_fdiag It identifies whether to use diag Approximation to speed up the algorithm.
#' @param s_frp Pre-processing by OMP method to reduce the number of parameters
#'
#' @return Coefficient vector
rcpp_lm_gaga <- function(X, y, s_alpha, s_itrNum, s_thresh, s_QR_flag, s_flag, s_lamda_0, s_fix_sigma, s_sigm2_0, s_fdiag, s_frp) {
    .Call(`_GAGAs_rcpp_lm_gaga`, X, y, s_alpha, s_itrNum, s_thresh, s_QR_flag, s_flag, s_lamda_0, s_fix_sigma, s_sigm2_0, s_fdiag, s_frp)
}

#' Fit a Cox model via the GAGA algorithm using cpp.
#'
#' Fit a Cox model via the Global Adaptive Generative Adjustment algorithm.
#' Part of this function refers to the coxphfit function in MATLAB 2016b.
#' @param X Input matrix, of dimension nobs*nvars; each row is an observation.
#' If the intercept term needs to be considered in the estimation process, then the first column of \code{X} must be all 1s.
#' @param y A n*1 matrix, indicating the survival time;
#' @param cens A n*1 matrix, consists of 0 and 1, 1 indicates that the row of data is censored, 0 is opposite.
#' @param alpha Hyperparameter. The suggested value for alpha is 2 or 3.
#' @param itrNum The number of iteration steps. In general, 20 steps are enough.
#' @param thresh Convergence threshold for beta Change, if \code{max(abs(beta-beta_old))<threshold}, return.
#' @param flag It identifies whether to make model selection. The default is \code{TRUE}.
#' @param lamda_0 The initial value of the regularization parameter for ridge regression.
#' @param fdiag It identifies whether to use diag Approximation to speed up the algorithm.
#'
#' @return Coefficient vector
cpp_COX_gaga <- function(X, y, cens, alpha = 2, itrNum = 50L, thresh = 0.001, flag = TRUE, lamda_0 = 0.5, fdiag = TRUE) {
    .Call(`_GAGAs_cpp_COX_gaga`, X, y, cens, alpha, itrNum, thresh, flag, lamda_0, fdiag)
}

#' Fit a logistic model via the Global Adaptive Generative Adjustment algorithm using cpp
#'
#' @param X Input matrix, of dimension nobs*nvars; each row is an observation.
#' If the intercept term needs to be considered in the estimation process, then the first column of \code{X} must be all 1s.
#' @param y should be either a factor with two levels.
#' @param s_alpha Hyperparameter. The suggested value for alpha is 1 or 2.
#' When the collinearity of the load matrix is serious, the hyperparameters can be selected larger, such as 5.
#' @param s_itrNum The number of iteration steps. In general, 20 steps are enough.
#' If the condition number of \code{X} is large, it is recommended to greatly increase the
#' number of iteration steps.
#' @param s_thresh Convergence threshold for beta Change, if \code{max(abs(beta-beta_old))<threshold}, return.
#' @param s_flag It identifies whether to make model selection. The default is \code{TRUE}.
#' @param s_lamda_0 The initial value of the regularization parameter for ridge regression.
#' The running result of the algorithm is not sensitive to this value.
#' @param s_fdiag It identifies whether to use diag Approximation to speed up the algorithm.
#'
#' @return Coefficient vector.
cpp_logistic_gaga <- function(X, y, s_alpha, s_itrNum, s_thresh, s_flag, s_lamda_0, s_fdiag) {
    .Call(`_GAGAs_cpp_logistic_gaga`, X, y, s_alpha, s_itrNum, s_thresh, s_flag, s_lamda_0, s_fdiag)
}

#' Fit a multinomial model via the GAGA algorithm using cpp
#'
#' Fit a multinomial model the Global Adaptive Generative Adjustment algorithm
#' @param X Input matrix, of dimension nobs*nvars; each row is an observation.
#' If the intercept term needs to be considered in the estimation process, then the first column of \code{X} must be all 1s.
#' @param y a One-hot response matrix or a \code{nc>=2} level factor
#' @param s_alpha Hyperparameter. The suggested value for alpha is 1 or 2.
#' When the collinearity of the load matrix is serious, the hyperparameters can be selected larger, such as 5.
#' @param s_itrNum The number of iteration steps. In general, 20 steps are enough.
#' If the condition number of \code{X} is large, it is recommended to greatly increase the
#' number of iteration steps.
#' @param s_thresh Convergence threshold for beta Change, if \code{max(abs(beta-beta_old))<threshold}, return.
#' @param s_flag It identifies whether to make model selection. The default is \code{TRUE}.
#' @param s_lamda_0 The initial value of the regularization parameter for ridge regression.
#' The running result of the algorithm is not sensitive to this value.
#' @param s_fdiag It identifies whether to use diag Approximation to speed up the algorithm.
#'
#' @return Coefficient matrix with K-1 columns beta_1,...,beta_{K-1} where K is the class number.
#' For k=1,..,K-1, the probability
#' \deqn{Pr(G=k|x)=exp(x^T beta_k) /(1+sum_{k=1}^{K-1}exp(x^T beta_k))}.
#' For k=K, the probability \deqn{Pr(G=K|x)=1/(1+sum_{k=1}^{K-1}exp(x^T beta_k))}.
#'
cpp_multinomial_gaga <- function(X, y, s_alpha, s_itrNum, s_thresh, s_flag, s_lamda_0, s_fdiag) {
    .Call(`_GAGAs_cpp_multinomial_gaga`, X, y, s_alpha, s_itrNum, s_thresh, s_flag, s_lamda_0, s_fdiag)
}

#' Fit a poisson model via the GAGA algorithm using cpp
#'
#' Fit a poisson model the Global Adaptive Generative Adjustment algorithm
#' @param X Input matrix, of dimension nobs*nvars; each row is an observation.
#' If the intercept term needs to be considered in the estimation process, then the first column of \code{X} must be all 1s.
#' In order to run the program stably, it is recommended that the value of X should not be too large. It is recommended to
#' preprocess all the items in X except the intercept item by means of preprocessing, so that the mean value of each column
#' is 0 and the standard deviation is \code{1/ colnum(X)}.
#' @param y Non-negative count response vector.
#' @param s_alpha Hyperparameter. The suggested value for alpha is 1 or 2.
#' When the collinearity of the load matrix is serious, the hyperparameters can be selected larger, such as 5.
#' @param s_itrNum The number of iteration steps. In general, 20 steps are enough.
#' If the condition number of \code{X} is large, it is recommended to greatly increase the
#' number of iteration steps.
#' @param s_thresh Convergence threshold for beta Change, if \code{max(abs(beta-beta_old))<threshold}, return.
#' @param s_flag It identifies whether to make model selection. The default is \code{TRUE}.
#' @param s_lamda_0 The initial value of the regularization parameter for ridge regression.
#' The running result of the algorithm is not sensitive to this value.
#' @param s_fdiag It identifies whether to use diag Approximation to speed up the algorithm.
#'
#' @return Coefficient vector.
#'
cpp_poisson_gaga <- function(X, y, s_alpha, s_itrNum, s_thresh, s_flag, s_lamda_0, s_fdiag) {
    .Call(`_GAGAs_cpp_poisson_gaga`, X, y, s_alpha, s_itrNum, s_thresh, s_flag, s_lamda_0, s_fdiag)
}

