% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_redundant_rows.R
\name{merge_redundant_rows}
\alias{merge_redundant_rows}
\title{Merge redundant rows}
\usage{
merge_redundant_rows(data, min_diff_peak2peak = NULL)
}
\arguments{
\item{data}{An object of class "GCalign". See \code{\link{align_chromatograms}} for details.}

\item{min_diff_peak2peak}{A numerical giving a threshold in minutes below which rows of similar retention time are checked for redundancy.}
}
\value{
a list of two items
\item{GCalign}{input data with updated input to \code{\link{gc_heatmap}}}
\item{peak_list}{a list of data frames containing the updated dataset}
}
\description{
Sometimes, redundant rows (i.e. groups of resembling a homologous peak) remain in an aligned dataset. This is the case when two or more adjacent rows exhibit a difference in the mean retention time that is greater than \code{min_diff_peak2peak}, the parameter that determines a threshold below that redundancy is checked within \code{\link{align_chromatograms}}. Therefore, this function allows to raise the threshold for a post processing step that groups the homologous peaks together without the need of repeating a potentially time-consuming alignment with adjusted parameters.
}
\details{
Based on the value of parameter \code{threshold}, possibly redundant rows are identified by comparing mean retention times. Next, rows are checked for redundancy. When one or more samples contain peaks in a pair of compared rows, no redundancy is existent and the pair is skipped.
}
\examples{
## Load example dataset
data("peak_data")
## Subset for faster processing
peak_data <- peak_data[1:3]
peak_data <- lapply(peak_data, function(x) x[1:50,])
## align data whith strict parameters
out <- align_chromatograms(peak_data, rt_col_name = "time",
max_diff_peak2mean = 0.01, min_diff_peak2peak = 0.02)
## relax threshold to merge redundant rows
out2 <- merge_redundant_rows(data = out, min_diff_peak2peak = 0.05)

}
\author{
Meinolf Ottensmann (meinolf.ottensmann@web.de) & Martin Stoffel (martin.adam.stoffel@gmail.com)
}
