% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemIntertemporal_4_4.R
\name{gemIntertemporal_4_4}
\alias{gemIntertemporal_4_4}
\title{An Intertemporal Model with Land, Two Consumers and Two Types of Firms}
\usage{
gemIntertemporal_4_4(...)
}
\arguments{
\item{...}{arguments to be passed to the function sdm2.}
}
\description{
An intertemporal (timeline) model with land, two consumers (i.e. a laborer and a land owner) and two types of firms.
The firms have CESAK production functions.
}
\examples{
\donttest{
np <- 5 # the number of planning periods.

n <- 4 * np - 2 # the number of commodity kinds
m <- 2 * (np - 1) + 2 # the number of agent kinds

names.commodity <- c(
  paste0("corn", 1:np),
  paste0("iron", 1:np),
  paste0("lab", 1:(np - 1)),
  paste0("land", 1:(np - 1))
)
names.agent <- c(
  paste0("firm.corn", 1:(np - 1)),
  paste0("firm.iron", 1:(np - 1)),
  "laborer", "land.owner"
)

# the exogenous supply matrix.
S0Exg <- matrix(NA, n, m, dimnames = list(names.commodity, names.agent))

S0Exg[paste0("lab", 1:(np - 1)), "laborer"] <- 100
S0Exg[paste0("land", 1:(np - 1)), "land.owner"] <- 100

S0Exg["corn1", c("laborer", "land.owner")] <- 25
S0Exg["iron1", c("laborer", "land.owner")] <- 100

# the output coefficient matrix.
B <- matrix(0, n, m, dimnames = list(names.commodity, names.agent))
for (k in 1:(np - 1)) {
  B[paste0("corn", k + 1), paste0("firm.corn", k)] <-
    B[paste0("iron", k + 1), paste0("firm.iron", k)] <- 1
}

dstl.firm.corn <- dstl.firm.iron <- list()
for (k in 1:(np - 1)) {
  dstl.firm.corn[[k]] <- node_new(
    "prod",
    type = "CESAK", es = 1, alphaK = 0.94,
    alpha = 1, betaK = 0.5,
    paste0("iron", k), paste0("VAT", k)
  )
  node_set(dstl.firm.corn[[k]], paste0("VAT", k),
    type = "SCES", es = 0.8,
    alpha = 1, beta = c(0.5, 0.5),
    paste0("lab", k), paste0("land", k)
  )

  dstl.firm.iron[[k]] <- node_new(
    "prod",
    type = "CESAK", es = 1, alphaK = 0.94,
    alpha = 2, betaK = 0.5,
    paste0("iron", k), paste0("VAT", k)
  )
  node_set(dstl.firm.iron[[k]], paste0("VAT", k),
    type = "SCES", es = 0.8,
    alpha = 1, beta = c(0.5, 0.5),
    paste0("lab", k), paste0("land", k)
  )
}

dst.laborer <- node_new(
  "util",
  type = "CD", alpha = 1, beta = prop.table(rep(1, np)),
  paste0("corn", 1:np)
)

dst.land.owner <- node_new(
  "util",
  type = "CD", alpha = 1, beta = prop.table(rep(1, np)),
  paste0("cc", 1:np)
)
for (k in 1:np) {
  node_set(
    dst.land.owner,
    paste0("cc", k),
    type = "CD", alpha = 1, beta = c(0.5, 0.5),
    paste0("corn", k), paste0("iron", k)
  )
}

ge <- sdm2(
  A = c(dstl.firm.corn, dstl.firm.iron, dst.laborer, dst.land.owner),
  B = B,
  S0Exg = S0Exg,
  names.commodity = names.commodity,
  names.agent = names.agent,
  numeraire = "lab1",
  ts = TRUE
)

ge$p
ge$z
ge$D
ge$S
ge$DV
ge$SV
}
}
