% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_networks.R
\name{simulate_networks}
\alias{simulate_networks}
\title{A Function to simulate networks from a GERGM with given theta parameters.}
\usage{
simulate_networks(formula, thetas, simulation_method = c("Metropolis",
  "Gibbs"), network_is_directed = TRUE,
  number_of_networks_to_simulate = 500, thin = 1, proposal_variance = 0.1,
  downweight_statistics_together = TRUE, MCMC_burnin = 100, seed = 123,
  GERGM_Object = NULL, return_constrained_networks = FALSE,
  optimize_proposal_variance = FALSE, target_accept_rate = 0.25,
  use_stochastic_MH = FALSE, stochastic_MH_proportion = 1,
  beta_correlation_model = FALSE, covariate_data = NULL, lambdas = NULL,
  ...)
}
\arguments{
\item{formula}{A formula object that specifies which statistics the user would
like to include while simulating the network, and the network the user is
providing as the initial network. Currently, the following statistics can be
specified: c("edges", "out2stars", "in2stars",     "ctriads", "mutual",
"ttriads").}

\item{thetas}{A vector of theta parameters given in the same order as the
formula terms, which the user would like to use to parameterize the model.}

\item{simulation_method}{Default is "Metropolis" which allows for exponential
down weighting, can also be "Gibbs".}

\item{network_is_directed}{Logical specifying whether or not the observed
network is directed. Default is TRUE.}

\item{number_of_networks_to_simulate}{Number of simulations generated for
estimation via MCMC. Default is 500.}

\item{thin}{The proportion of samples that are kept from each simulation. For
example, thin = 1/200 will keep every 200th network in the overall simulated
sample. Default is 1.}

\item{proposal_variance}{The variance specified for the Metropolis Hastings
simulation method. This parameter is inversely proportional to the average
acceptance rate of the M-H sampler and should be adjusted so that the average
acceptance rate is approximately 0.25. Default is 0.1.}

\item{downweight_statistics_together}{Logical specifying whether or not the
weights should be applied inside or outside the sum. Default is TRUE and user
should not select FALSE under normal circumstances.}

\item{MCMC_burnin}{Number of samples from the MCMC simulation procedure that
will be discarded before drawing the samples used for estimation. Default is
100.}

\item{seed}{Seed used for reproducibility. Default is 123.}

\item{GERGM_Object}{Optional argument allowing the user to supply a GERGM
object output by the gergm() estimation function in order to simulate further
networks. Defaults to NULL. If a GERGM object is provided, any user specified
parameter values will be ignored and the final parameter estimates from the
gergm() function will be used instead. When using this option, the following
terms must still be specified: number_of_networks_to_simulate, thin, and
MCMC_burnin. proposal_variance may also be specified, or if set equal to NULL,
then the proposal variance from parameter estimation will be used instead (
this option is likely preferred in most situations).}

\item{return_constrained_networks}{Logical argument indicating whether
simulated networks should be transformed back to observed scale or whether
constrained [0,1] networks should be returned. Defaults to FALSE, in which
case networks are returned on observed scale.}

\item{optimize_proposal_variance}{Logical indicating whether proposal
variance should be optimized if using Metropolis Hastings for simulation.
Defaults to FALSE.}

\item{target_accept_rate}{Defaults to 0.25, can be used to optimize
Metropolis Hastings simulations.}

\item{use_stochastic_MH}{A logical indicating whether a stochastic approximation
to the h statistics should be used under Metropolis Hastings in-between
thinned samples. This may dramatically speed up estimation. Defaults to FALSE.
HIGHLY EXPERIMENTAL!}

\item{stochastic_MH_proportion}{Percentage of dyads/triads to use for
approximation, defaults to 0.25}

\item{beta_correlation_model}{Defaults to FALSE. If TRUE, then the beta
correlation model is estimated. A correlation network must be provided, but
all covariates and undirected statistics may be supplied as normal.}

\item{covariate_data}{A data frame containing node level covariates the user
wished to transform into sender or receiver effects. It must have row names
that match every entry in colnames(raw_network), should have descriptive
column names.  If left NULL, then no sender or receiver effects will be
added.}

\item{lambdas}{A vector of lambda parameters given in the same order as the
formula terms, which the user would like to use to parameterize the model.
Covariate effects should be specified after endogenous effects.}

\item{...}{Optional arguments, currently unsupported.}
}
\value{
A list object containing simulated networks and parameters used to
specify the simulation. See the $MCMC_Output field for simulated networks. If
GERGM_Object is provided, then a GERGM object will be returned instead.
}
\description{
Simulates networks from a GERGM for a given set of parameter values.
}
\examples{
\dontrun{
set.seed(12345)
net <- matrix(runif(100),10,10)
diag(net) <- 0
colnames(net) <- rownames(net) <- letters[1:10]
formula <- net ~ edges + ttriads + in2stars

test <- simulate_networks(formula,
 thetas = c(0.6,-0.8),
 lambdas = 0.2,
 number_of_networks_to_simulate = 100,
 thin = 1/10,
 proposal_variance = 0.5,
 MCMC_burnin = 100,
 seed = 456)

# preferred method for specifying a null model
formula <- net ~ edges(method = "endogenous")
test <- simulate_networks(
 formula,
 thetas = 0,
 number_of_networks_to_simulate = 100,
 thin = 1/10,
 proposal_variance = 0.5,
 MCMC_burnin = 100,
 seed = 456)
 }
}
