g.report.part4 = function(datadir=c(),metadatadir=c(),loglocation = c(),f0=c(),f1=c(),storefolderstructure=TRUE) {
  # description: function to merge generate report from milestone data generated by g.part4 (if store.ms was set to TRUE)
  ms4.out = "/meta/ms4.out"
  if (file.exists(paste(metadatadir,ms4.out,sep=""))) {
    if (length(dir(paste(metadatadir,ms4.out,sep=""))) == 0) {
      try.generate.report = FALSE
    } else {
      try.generate.report = TRUE
    }
  } else {
    try.generate.report = FALSE
  }
  if (try.generate.report == TRUE) {
    resultfolder = metadatadir #resultfolder = "Q:/studies/sleep/output_pi_sleep_wrist"
    meta.sleep.folder = paste(metadatadir,"/meta/ms3.out",sep="")
    if (length(loglocation) > 0) {
      only.use.sleeplog = TRUE
    } else {
      only.use.sleeplog = FALSE
    }
    #============================================================================
    # Go through accelerometer datafiles and merge with sleep log data
    fnames = dir(meta.sleep.folder)
    if (f1 > length(fnames)) {
      print(paste("f1 changed from, ",f1," to ",length(fnames),sep=""))
      f1 = length(fnames)
    }
    if (length(f1) == 0 | f1 > length(fnames))  f1 = length(fnames)
    #-----------------------------------------------------
    nightsummary2 = as.data.frame(matrix(0,0,31)) 
    colnames(nightsummary2) = c("ID", "night","sleeponset", "wakeup", "SptDuration", "sleepparam", 
                                "guider_onset", "guider_wakeup", "guider_SptDuration",
                                "error_onset", "error_wake", "error_dur",
                                "fraction_night_invalid",
                                "SleepDurationInSpt","duration_sib_wakinghours","number_sib_sleepperiod","number_sib_wakinghours",
                                "duration_sib_wakinghours_atleast15min",
                                "sleeponset_ts","wakeup_ts","guider_onset_ts", "guider_wakeup_ts",
                                "page","daysleeper","weekday","calendar_date","filename",
                                "cleaningcode","guider_used","acc_available","guider")
    sumi = 1
    sleeplog_used = rep(" ",((f1-f0)+1))
    fnames.ms4 = list.files(paste0(metadatadir,ms4.out),full.names=TRUE)
    if(length(fnames.ms4) < f1) f1 = length(fnames.ms4)
    cat(" loading all the milestone data from part 4 this can take a few minutes\n")
    myfun = function(x) { 
      load(file=x)
      cut = which(nightsummary[,1] == "")
      if (length(cut) > 0 & length(cut) < nrow(nightsummary)) {
        nightsummary = nightsummary[-cut,]
      }
      out = as.matrix(nightsummary)
    }
    
    nightsummary2 = as.data.frame(do.call(rbind,lapply(fnames.ms4,myfun)),stringsAsFactors=FALSE)
    skip = FALSE
    if (length(nightsummary2) != 0) {
      NumberNotNA = length(which(is.na(nightsummary2[,3:24]) == FALSE))
      if (NumberNotNA == 0) {
        skip = TRUE
        warning("\nCannot create report part 4 report, because no sleep estimates present in milestone data.")
      }
    } else {
      skip = TRUE
      warning("\nCannot create report part 4 report, because no milestone data found for part4.")
    }
    if (skip == FALSE) { # skip if no data was loaded or if it all rows were NA values
      #----------------
      nightsummary = nightsummary2
      pko = which(nightsummary$sleeponset == 0 & nightsummary$wakeup == 0 & nightsummary$SptDuration == 0)
      if (length(pko) > 0) {
        nightsummary = nightsummary[-pko,]
      }
      #####################################################
      # COLLAPSING nightsummary TO A ONELINE personsummary PER PARTICIPANT
      if (nrow(nightsummary) == 0) {
        print("report not stored, because no results available")
      } else {
        write.csv(nightsummary,file=paste(resultfolder,"/results/QC/part4_nightsummary_sleep_full.csv",sep=""),row.names=FALSE)
        nightsummary_bu = nightsummary
      }
      ####
      summarynames_backup = c()
      for (dotwice in 1:2) { #store data twice, once full and once cleaned
        if (dotwice == 2) {
          # ignore nights that were derived without sleep log?
          if (only.use.sleeplog == TRUE) {
            del = which(nightsummary$cleaningcode > 0 | nightsummary$sleeplog_used == "FALSE")
          } else {
            #only delete nights with no or no valid accelerometer data data, but consider nigths with missing sleep log data
            del = which(nightsummary$cleaningcode > 1) 
          }
          if (length(del) > 0) {
            nightsummary = nightsummary_bu[-del,]
          }
          # ignore also all columns related to sleeplog and error, which were mainly used for methodological research
          coldel = which(colnames(nightsummary) %in% c("guider_onset", "guider_wakeup", "guider_SptDuration",
                                                    "error_onset", "error_wake", "error_dur",
                                                    "guider_onset_ts", "guider_wakeup_ts") == TRUE)
          if (length(coldel) > 0) nightsummary = nightsummary[,-coldel]
        }
        NIDS = length(unique(nightsummary$ID))
        NDEF = length(unique(nightsummary$sleepparam))
        uuu = unique(nightsummary$sleepparam)
        rem = which(uuu == 0 | uuu == "0" | is.na(uuu) == TRUE)
        if (length(rem) > 0) {
          uuu = uuu[-rem]
          NDEF = length(uuu)
        }
        if (storefolderstructure==TRUE) {
          personSummary = matrix(0,NIDS,((NDEF*3*19)+13+(6*3)))
        } else {
          personSummary = matrix(0,NIDS,((NDEF*3*19)+11+(6*3)))
        }
        uid = unique(nightsummary$ID)
        if (nrow(nightsummary) > 0) {
          for (i in 1:length(uid)) {
            personSummarynames = c() #moved here on 3/12/2014
            # fully cleaned from nights that need to be deleted
            nightsummary.tmp = nightsummary[which(nightsummary$ID == uid[i]),] #back up
            udef = as.character(unique(nightsummary.tmp$sleepparam))
            if(length(which(as.character(udef)=="0") > 0)) udef = udef[-c(which(as.character(udef)=="0"))]
            udefn = udef
            #-------------------------------------------
            # general info about file
            personSummary[i,1] = uid[i] #id
            personSummarynames = c(personSummarynames,"ID")
            personSummary[i,2] = as.character(nightsummary$filename[which(nightsummary$ID == uid[i])][1]) #filename
            if (length(unlist(strsplit(as.character(personSummary[i,2]),".RDa"))) > 1) personSummary[i,2] = unlist(strsplit(personSummary[i,2],".RDa"))[1]
            personSummarynames = c(personSummarynames,"filename")
            cntt = 2
            personSummary[i,cntt+1] = as.character(nightsummary$calendar_date[which(nightsummary$ID == uid[i])][1]) #date
            personSummarynames = c(personSummarynames,"calendar_date")
            personSummary[i,cntt+2] = nightsummary$weekday[which(nightsummary$ID == uid[i])][1] #date
            personSummarynames = c(personSummarynames,"weekday")
            # sleep log used
            personSummary[i,cntt+3] = as.character(nightsummary.tmp$sleeplog_used[1])
            personSummarynames = c(personSummarynames,paste("sleeplog_used",sep=""))
            
            # total number of nights with acceleration and accelerometer worn
            personSummary[i,cntt+4] = length(which(
              (nightsummary.tmp$acc_available[which(nightsummary.tmp$sleepparam == udef[1])] == "TRUE" |
                 nightsummary.tmp$acc_available[which(nightsummary.tmp$sleepparam == udef[1])] == "1") &
                nightsummary.tmp$cleaningcode[which(nightsummary.tmp$sleepparam == udef[1])] != 2))
            personSummarynames = c(personSummarynames,paste("n_nights_acc",sep=""))
            # total number of nights with sleep log
            TOTALNIGHTS = length(nightsummary.tmp$night[which(nightsummary.tmp$sleepparam == udef[1] & nightsummary.tmp$cleaningcode != 1 )]) # number of total nights
            personSummary[i,cntt+5] = TOTALNIGHTS
            personSummarynames = c(personSummarynames,paste("n_nights_sleeplog",sep=""))
            # total number of complete weekend and week nights
            th3 = nightsummary.tmp$weekday[which(nightsummary.tmp$sleepparam == udef[1])]
            
            if (only.use.sleeplog == TRUE) {
              validcleaningcode = 0
            } else if (only.use.sleeplog == FALSE) {
              validcleaningcode = 1
            }
            personSummary[i,cntt+6] = length(which(nightsummary.tmp$cleaningcode[which(nightsummary.tmp$sleepparam == udef[1])] <= validcleaningcode &
                                                     (th3 == "Friday" | th3 == "Saturday")))
            personSummary[i,cntt+7] = length(which(nightsummary.tmp$cleaningcode[which(nightsummary.tmp$sleepparam == udef[1])] <= validcleaningcode &
                                                     (th3 == "Monday" | th3 == "Tuesday" | th3 == "Wednesday" | th3 == "Thursday" | th3 == "Sunday")))
            personSummarynames = c(personSummarynames,paste("n_WE_nights_complete",sep=""),
                                   paste("n_WD_nights_complete",sep=""))
            # number of days with sleep during the day
            personSummary[i,cntt+8] = length(which(nightsummary.tmp$daysleep[which(nightsummary.tmp$sleepparam == udef[1])] == 1 &
                                                     (th3 == "Friday" | th3 == "Saturday")))
            personSummary[i,cntt+9] = length(which(nightsummary.tmp$daysleep[which(nightsummary.tmp$sleepparam == udef[1])] == 1 &
                                                     (th3 == "Monday" | th3 == "Tuesday" | th3 == "Wednesday" | th3 == "Thursday" | th3 == "Sunday")))
            personSummarynames = c(personSummarynames,paste("n_WEnights_daysleeper",sep=""),
                                   paste("n_WDnights_daysleeper",sep=""))
            cnt = cntt+9
            #-------------------------------------------
            # sleep log summary
            if (dotwice == 1) {
              nightsummary.tmp$guider_SptDuration = as.numeric(nightsummary.tmp$guider_SptDuration)
              nightsummary.tmp$guider_onset = as.numeric(nightsummary.tmp$guider_onset)
              nightsummary.tmp$guider_wakeup = as.numeric(nightsummary.tmp$guider_wakeup)
            }
            nightsummary.tmp$SptDuration = as.numeric(nightsummary.tmp$SptDuration)
            nightsummary.tmp$sleeponset = as.numeric(nightsummary.tmp$sleeponset)
            nightsummary.tmp$wakeup = as.numeric(nightsummary.tmp$wakeup)
            
            nightsummary.tmp$SleepDurationInSpt = as.numeric(nightsummary.tmp$SleepDurationInSpt)
            nightsummary.tmp$number_sib_sleepperiod = as.numeric(nightsummary.tmp$number_sib_sleepperiod)
            nightsummary.tmp$duration_sib_wakinghours = as.numeric(nightsummary.tmp$duration_sib_wakinghours)
            nightsummary.tmp$number_sib_wakinghours = as.numeric(nightsummary.tmp$number_sib_wakinghours)
            nightsummary.tmp$duration_sib_wakinghours_atleast15min = as.numeric(nightsummary.tmp$duration_sib_wakinghours_atleast15min)
            weekday = nightsummary.tmp$weekday[which(nightsummary.tmp$sleepparam == udef[1])]
            if (dotwice == 1) {
              for (k in 1:3) {
                if (k == 1) {
                  TW = "AD"
                  Seli = 1:length(weekday)
                } else if (k == 2) {
                  TW = "WD"
                  Seli = which(weekday == "Monday" | weekday == "Tuesday" | weekday == "Wednesday" | weekday == "Thursday" | weekday == "Sunday")
                } else if (k == 3) {
                  TW = "WE"
                  Seli = which(weekday == "Friday" | weekday == "Saturday")              
                }
                
                personSummary[i,cnt+1] = mean(nightsummary.tmp$guider_SptDuration[which(nightsummary.tmp$sleepparam == udef[1])[Seli]],na.rm=TRUE)
                personSummary[i,cnt+2] = sd(nightsummary.tmp$guider_SptDuration[which(nightsummary.tmp$sleepparam == udef[1])[Seli]],na.rm=TRUE)
                personSummarynames = c(personSummarynames,paste("guider_SptDuration_",TW,"_mn",sep=""),
                                       paste("guider_SptDuration_",TW,"_sd",sep=""))
                personSummary[i,cnt+3] = mean(nightsummary.tmp$guider_onset[which(nightsummary.tmp$sleepparam == udef[1])[Seli]],na.rm=TRUE)
                personSummary[i,cnt+4] = sd(nightsummary.tmp$guider_onset[which(nightsummary.tmp$sleepparam == udef[1])[Seli]],na.rm=TRUE)
                personSummarynames = c(personSummarynames,paste("guider_onset_",TW,"_mn",sep=""),
                                       paste("guider_onset_",TW,"_sd",sep=""))
                personSummary[i,cnt+5] = mean(nightsummary.tmp$guider_wakeup[which(nightsummary.tmp$sleepparam == udef[1])[Seli]],na.rm=TRUE)
                personSummary[i,cnt+6] = sd(nightsummary.tmp$guider_wakeup[which(nightsummary.tmp$sleepparam == udef[1])[Seli]],na.rm=TRUE)
                personSummarynames = c(personSummarynames,paste("guider_wakeup_",TW,"_mn",sep=""),
                                       paste("guider_wakeup_",TW,"_sd",sep=""))
                cnt = cnt + 6
              }
            }
            nightsummary$cleaningcode = as.numeric(nightsummary$cleaningcode)
            nightsummary$ID = as.character(nightsummary$ID)
            uid = as.character(uid)
            #-------------------------------------------
            # accelerometer summary
            #----------------------------------------------
            if (only.use.sleeplog == FALSE) { #when sleep log is not available
              if (dotwice == 2) {
                CRIT = which(nightsummary$ID == uid[i] & (nightsummary$cleaningcode == 0 | nightsummary$cleaningcode == 1))
              } else {
                CRIT = which(nightsummary$ID == uid[i])
              }
            } else {
              CRIT = which(nightsummary$ID == uid[i] & nightsummary$cleaningcode == 0) #when sleep log is available
            }
            personSummarynames_backup = c()
            if (length(CRIT) > 0) { #summarise data if there is data
              #-----------------------------------------------
              for (j in 1:length(udef)) {
                weekday = nightsummary.tmp$weekday[which(nightsummary.tmp$sleepparam == udef[j])]
                for (k in 1:3) {
                  if (ncol(personSummary) < (cnt + 22)) { # expand personSummary matrix if there is a change that is not big enough
                    expansion = as.matrix(personSummary[,(cnt+1):ncol(personSummary)])
                    if (nrow(expansion) != nrow(personSummary)) expansion = t(expansion)
                    personSummary = cbind(personSummary,expansion)
                  }
                  if (k == 1) {
                    TW = "AD"
                    Seli = 1:length(weekday)
                  } else if (k == 2) {
                    TW = "WD"
                    Seli = which(weekday == "Monday" | weekday == "Tuesday" | weekday == "Wednesday" | weekday == "Thursday" | weekday == "Sunday")
                  } else if (k == 3) {
                    TW = "WE"
                    Seli = which(weekday == "Friday" | weekday == "Saturday")              
                  }
                  indexUdef = which(nightsummary.tmp$sleepparam == udef[j])[Seli]
                  personSummary[i,(cnt+1)] = mean(nightsummary.tmp$SptDuration[indexUdef],na.rm=TRUE)
                  personSummary[i,(cnt+2)] = sd(nightsummary.tmp$SptDuration[indexUdef],na.rm=TRUE)
                  personSummarynames = c(personSummarynames,paste("SptDuration_",TW,"_",udefn[j],"_mn",sep=""),
                                         paste("SptDuration_",TW,"_",udefn[j],"_sd",sep=""))
                  personSummary[i,(cnt+3)] = mean(nightsummary.tmp$SleepDurationInSpt[indexUdef],na.rm=TRUE)
                  personSummary[i,(cnt+4)] = sd(nightsummary.tmp$SleepDurationInSpt[indexUdef],na.rm=TRUE)
                  personSummarynames = c(personSummarynames,paste("SleepDurationInSpt_",TW,"_",udefn[j],"_mn",sep=""),
                                         paste("SleepDurationInSpt_",TW,"_",udefn[j],"_sd",sep=""))
                  personSummary[i,(cnt+5)] = mean(nightsummary.tmp$SleepDurationInSpt[indexUdef] /
                                                    nightsummary.tmp$SptDuration[indexUdef],na.rm=TRUE)
                  personSummary[i,(cnt+6)] = sd(nightsummary.tmp$SleepDurationInSpt[indexUdef] /
                                                  nightsummary.tmp$SptDuration[indexUdef],na.rm=TRUE)
                  personSummarynames = c(personSummarynames,paste("sleep_efficiency_",TW,"_",udefn[j],"_mn",sep=""),
                                         paste("sleep_efficiency_",TW,"_",udefn[j],"_sd",sep=""))
                  personSummary[i,(cnt+7)] = mean(nightsummary.tmp$duration_sib_wakinghours[indexUdef],na.rm=TRUE)
                  personSummary[i,(cnt+8)] = sd(nightsummary.tmp$duration_sib_wakinghours[indexUdef],na.rm=TRUE)
                  personSummarynames = c(personSummarynames,paste("duration_sib_wakinghours_",TW,"_",udefn[j],"_mn",sep=""),
                                         paste("duration_sib_wakinghours_",TW,"_",udefn[j],"_sd",sep=""))
                  personSummary[i,(cnt+9)] = mean(nightsummary.tmp$number_sib_sleepperiod[indexUdef],na.rm=TRUE)
                  personSummary[i,(cnt+10)] = sd(nightsummary.tmp$number_sib_sleepperiod[indexUdef],na.rm=TRUE)
                  personSummarynames = c(personSummarynames,paste("number_sib_sleepperiod_",TW,"_",udefn[j],"_mn",sep=""),
                                         paste("number_sib_sleepperiod_",TW,"_",udefn[j],"_sd",sep=""))
                  personSummary[i,(cnt+11)] = mean(nightsummary.tmp$number_sib_wakinghours[indexUdef],na.rm=TRUE)
                  personSummary[i,(cnt+12)] = sd(nightsummary.tmp$number_sib_wakinghours[indexUdef],na.rm=TRUE)
                  personSummarynames = c(personSummarynames,paste("number_sib_wakinghours_",TW,"_",udefn[j],"_mn",sep=""),
                                         paste("number_sib_wakinghours_",TW,"_",udefn[j],"_sd",sep=""))
                  personSummary[i,(cnt+13)] = mean(nightsummary.tmp$duration_sib_wakinghours_atleast15min[indexUdef],na.rm=TRUE)
                  personSummary[i,(cnt+14)] = sd(nightsummary.tmp$duration_sib_wakinghours_atleast15min[indexUdef],na.rm=TRUE)
                  personSummarynames = c(personSummarynames,paste("duration_sib_wakinghours_atleast15min_",TW,"_",udefn[j],"_mn",sep=""),
                                         paste("duration_sib_wakinghours_atleast15min_",TW,"_",udefn[j],"_sd",sep=""))
                  
                  # average sibd during the day
                  AVEsibdDUR = c(nightsummary.tmp$duration_sib_wakinghours[indexUdef] /
                                   nightsummary.tmp$number_sib_wakinghours[indexUdef])
                  if (length(which(nightsummary.tmp$number_sib_wakinghours[indexUdef] == 0))) {
                    AVEsibdDUR[which(nightsummary.tmp$number_sib_wakinghours[indexUdef] == 0)] = 0
                  }
                  personSummary[i,(cnt+15)] = mean(AVEsibdDUR,na.rm=TRUE)
                  personSummary[i,(cnt+16)] = sd(AVEsibdDUR,na.rm=TRUE)
                  personSummarynames = c(personSummarynames,paste("average_dur_sib_wakinghours_",TW,"_",udefn[j],"_mn",sep=""),
                                         paste("average_dur_sib_wakinghours_",TW,"_",udefn[j],"_sd",sep=""))
                  NDAYsibd = length(which(nightsummary.tmp$number_sib_wakinghours[indexUdef] > 0))
                  if (length(NDAYsibd) == 0) NDAYsibd = 0
                  personSummary[i,(cnt+17)] = NDAYsibd
                  personSummarynames = c(personSummarynames,paste("n_days_w_sib_wakinghours_",TW,"_",udefn[j],sep=""))
                  personSummary[i,(cnt+18)] = mean(nightsummary.tmp$sleeponset[indexUdef],na.rm=TRUE)
                  personSummary[i,(cnt+19)] = sd(nightsummary.tmp$sleeponset[indexUdef],na.rm=TRUE)
                  personSummarynames = c(personSummarynames,paste("sleeponset_",TW,"_",udefn[j],"_mn",sep=""),
                                         paste("sleeponset_",TW,"_",udefn[j],"_sd",sep=""))
                  personSummary[i,(cnt+20)] = mean(nightsummary.tmp$wakeup[indexUdef],na.rm=TRUE)
                  personSummary[i,(cnt+21)] = sd(nightsummary.tmp$wakeup[indexUdef],na.rm=TRUE)
                  personSummarynames = c(personSummarynames,paste("wakeup_",TW,"_",udefn[j],"_mn",sep=""),
                                         paste("wakeup_",TW,"_",udefn[j],"_sd",sep=""))
                  cnt = cnt + 21
                }
              }
              personSummarynames_backup = personSummarynames #if (length(personSummarynames) >= 29)
            }
          }
          # replace matrix values "NA" and "NaN" by empty cells
          for (colli in 1:ncol(personSummary)) {
            missingv = which(is.na(personSummary[,colli]) == TRUE | personSummary[,colli] == "NA" |  personSummary[,colli] == "NaN")
            if (length(missingv) > 0) {
              personSummary[missingv,colli] = ""
            }
          }
          personSummary = as.data.frame(personSummary, stringsAsFactors = TRUE)
          if (length(personSummarynames) != ncol(personSummary)) {
            if (length(personSummarynames_backup) > 0) {
              names(personSummary) = personSummarynames_backup
            } else {
              if (length(personSummarynames) >ncol(personSummary)) {
                names(personSummary)[1:length(personSummarynames)] = personSummarynames
              } else {
                names(personSummary) = personSummarynames[1:ncol(personSummary)]
              }
            }
          } else {
            names(personSummary) =personSummarynames
          }
          # remove empty columns in personpersonSummary, if any
          emptycolumns = which(is.na(colnames(personSummary)) == TRUE)
          if (length(emptycolumns) > 0) {
            personSummary = personSummary[,-emptycolumns]
          }
        }
        #######################################################
        if (nrow(nightsummary) == 0) {
          print("report not stored, because no results available")
        } else {
          if (dotwice == 1) {
            write.csv(nightsummary,file=paste(resultfolder,"/results/QC/part4_nightsummary_sleep_full.csv",sep=""),row.names=FALSE)
            write.csv(personSummary,file=paste(resultfolder,"/results/QC/part4_summary_sleep_full.csv",sep=""),row.names=FALSE)
          } else {
            write.csv(nightsummary,file=paste(resultfolder,"/results/part4_nightsummary_sleep_cleaned.csv",sep=""),row.names=FALSE)
            write.csv(personSummary,file=paste(resultfolder,"/results/part4_summary_sleep_cleaned.csv",sep=""),row.names=FALSE)
          }
        }
      }  
      # this code is now part of g.part4
      # SI = sessionInfo() 
      # save(SI,file=paste(resultfolder,"/results/QC/sessioninfo_part4.RData",sep=""))
    }
  }
}
