g.report.part6 = function(metadatadir = c(), f0 = c(), f1 = c(),
                          params_cleaning = NULL, params_output,
                          verbose = TRUE) {
  # description: function to load milestone data generated by g.part6 and to merge these into a spreadsheet
  # here no additional information of analyses are added. This function therefore is primary to wrap up the up the output
  # from parallel processed accelerometer files
  ms6.out = "/meta/ms6.out"
  if (file.exists(paste(metadatadir, ms6.out, sep = ""))) {
    if (length(dir(paste(metadatadir, ms6.out, sep = ""))) == 0) {
      try.generate.report = FALSE #do not run this function if there is no milestone data from g.part5
    } else {
      try.generate.report = TRUE
    }
  } else {
    try.generate.report = FALSE #do not run this function if there is no milestone data from g.part5
    warning(paste0('Cannot generate part6 report because no part 6 milestone data",
                   " is available. First run part 6 with argument mode=6.'))
  }
  if (try.generate.report == TRUE) {
    #======================================================================
    # loop through meta-files
    fnames.ms6 = list.files(paste0(metadatadir, ms6.out), full.names = TRUE)
    if (f1 > length(fnames.ms6)) {
      f1 = length(fnames.ms6)
    }
    if (verbose == TRUE) {
      cat(paste0(" loading all the milestone data from part 6 this can",
                 " take a few minutes\n"))
    }
    myfun = function(x, expectedCols = c()) {
      output_part6 = NULL
      load(file = x)
      cut = which(output_part6[, 1] == "")
      if (length(cut) > 0 & length(cut) < nrow(output_part6)) {
        output_part6 = output_part6[-cut, which(colnames(output_part6) != "")]
      }
      out = as.matrix(output_part6)
      if (length(expectedCols) > 0) {
        tmp = as.data.frame(matrix(0, 0, length(expectedCols)))
        colnames(tmp) = expectedCols
        out = base::merge(tmp, out, all = TRUE)
      }
      if (any(c("cosinorIS", "cosinorIV", "GGIRversion") %in% colnames(out) == FALSE)) {
        out = as.data.frame(out)
        out$cosinorIS = NA
        out$cosinorIV = NA
        out$GGIRversion = ""
      }
      return(out)
    }
    out_try = myfun(fnames.ms6[f0])
    # If first recording has cosinor estimates then we know that circadian 
    # rhythm analysis was done. Column names can be used as reference point.
    # If cosinor estimates are NOT present: Use largest output file for 
    # initializing column names.
    if (length(grep("cosinor", x = colnames(out_try))) == 0) {
      all_files <- fnames.ms6[f0:f1]
      file_info <- file.info(all_files)
      file_sizes <- file_info$size
      # Find the file with the largest size. Since the .RData files in ms6.out are processed, the largest file is likely to have the most column names.
      largest_file <- all_files[which.max(file_sizes)]
      # Extract column names from this file
      out_try <- myfun(largest_file)
    }
    expectedCols = colnames(out_try)
    outputfinal = as.data.frame(do.call(rbind,
                                        lapply(fnames.ms6[f0:f1], myfun, expectedCols)),
                                stringsAsFactors = FALSE)
    outputfinal = outputfinal[,which(colnames(outputfinal) %in% c("cosinorIS", "cosinorIV") == FALSE)]
    # Find columns filled with missing values
    cut = which(sapply(outputfinal, function(x) all(x == "")) == TRUE)
    if (length(cut) > 0) {
      outputfinal = outputfinal[,-cut]
    }
    # order data.frame
    outputfinal = outputfinal[order(outputfinal$filename, outputfinal$ID),]
    #-------------------------------------------------------------
    # store all summaries in csv files
    outputfinal_clean = tidyup_df(outputfinal)
    data.table::fwrite(outputfinal_clean, paste0(metadatadir, "/results/part6_summary.csv"),
                       row.names = FALSE, na = "", sep = params_output[["sep_reports"]],
                       dec = params_output[["dec_reports"]])
    rm(outputfinal)
  }
}
