% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_outlier_in_GeoSpace.R
\name{ggoutlier_geoKNN}
\alias{ggoutlier_geoKNN}
\title{GGoutlieR with the geographical KNN approach}
\usage{
ggoutlier_geoKNN(
  geo_coord,
  gen_coord,
  min_nn_dist = 100,
  k = NULL,
  klim = c(3, 50),
  s = 100,
  make_fig = FALSE,
  plot_dir = ".",
  w_power = 1,
  p_thres = 0.05,
  n = 10^6,
  multi_stages = TRUE,
  maxIter = NULL,
  keep_all_stg_res = FALSE,
  warning_minR2 = 0.9,
  cpu = 1,
  verbose = TRUE
)
}
\arguments{
\item{geo_coord}{matrix or data.frame with two columns. The first column is longitude and the second one is latitude.}

\item{gen_coord}{matrix. A matrix of "coordinates in a genetic space". Users can provide ancestry coefficients or eigenvectors for calculation. If, for example, ancestry coefficients are given, each column corresponds to an ancestral population. Samples are ordered in rows as in `geo_coord`.}

\item{min_nn_dist}{numeric. A minimal geographical distance for searching KNNs. Neighbors of a focal sample within this distance will be excluded from the KNN searching procedure.}

\item{k}{integer. Number of the nearest neighbors.}

\item{klim}{vector. A range of K to search for the optimal number of nearest neighbors. The default is `klim = c(3, 50)`}

\item{s}{integer. A scalar of geographical distance. The default `s=100` scales the distance to a unit of 0.1 kilometer.}

\item{make_fig}{logic. If `make_fig = TRUE`, plots for diagnosing GGoutlieR analysis will be generated and saved to `plot_dir`. The default is `FALSE`}

\item{plot_dir}{string. The path to save plots}

\item{w_power}{numeric. A value controlling the power of distance weight in geographical KNN prediction.}

\item{p_thres}{numeric. A significance level}

\item{n}{numeric. A number of random samples to draw from the null distribution for making a graph.}

\item{multi_stages}{logic. A multi-stage test will be performed if is `TRUE` (the default is `TRUE`).}

\item{maxIter}{numeric. Maximal iteration number of multi-stage KNN test.}

\item{keep_all_stg_res}{logic. Results from all iterations of the multi-stage test will be retained if it is`TRUE`. (the default is `FALSE`)}

\item{warning_minR2}{numeric. The prediction accuracy of KNN is evaluated as R^2 to assess the violation of isolation-by-distance expectation. If any R^2 is larger than `warning_minR2`, a warning message will be reported at the end of your analysis.}

\item{cpu}{integer. Number of CPUs to use for searching the optimal K.}

\item{verbose}{logic. If `verbose = FALSE`, `ggoutlier` will suppress printout messages.}
}
\value{
an object of `list` including five items. `statistics` is a `data.frame` consisting of the `D genetics` ("Dg") values, p values and a column of logic values showing if a sample is an outlier or not. `threshold` is a `data.frame` recording the significance threshold. `gamma_parameter` is a vector recording the parameter of the heuristic Gamma distribution. `knn_index` and `knn_name` are a `data.frame` recording the K nearest neighbors of each sample.
}
\description{
identify samples genetically different from K nearest geographical neighbors (geographical KNN). For the details of the outlier detection approach, please see the supplementary material of Chang and Schmid 2023 (doi:https://doi.org/10.1101/2023.04.06.535838)
}
