% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRglmGOF.R
\name{RRglmGOF}
\alias{RRglmGOF}
\title{Goodness-of-fit statistics for binary Randomized Response data}
\usage{
RRglmGOF(formula, data, glmOutput, doPearson = TRUE, doDeviance = TRUE,
  doHlemeshow = TRUE, hlemeshowGroups = 10, rm.na = TRUE, print = TRUE)
}
\arguments{
\item{formula}{a two-sided linear formula object describing the model to be fitted,
with the response on the left of a ~ operator and the terms, separated by + operators, on the right.}

\item{data}{a data frame containing the variables named in \code{\link{formula}}.}

\item{glmOutput}{a model fitted with the \code{\link{RRglm}} function.}

\item{doPearson}{compute Pearson statistic.}

\item{doDeviance}{compute Deviance statistic.}

\item{doHlemeshow}{compute Hosmer-Lemeshow statistic.}

\item{hlemeshowGroups}{number of groups to split the data into for the Hosmer-Lemeshow statistic (default: 10).}

\item{rm.na}{remove cases with missing data.}

\item{print}{print summary of goodness-of-fit statistics.}
}
\value{
an option of class RRglmGOF.
}
\description{
Compute goodness-of-fit statistics for binary Randomized Response data.
Pearson, Deviance and Hosmer-Lemeshow statistics are available.
Reference: Fox, J-P, Klotzke, K. and Veen, D. (2016). \emph{Generalized Linear Mixed Models for Randomized
Responses.} Manuscript submitted for publication.
}
\examples{
out <- RRglm(response ~ Gender + RR + pp + age, link="RRlink.logit", RRmodel=RRmodel,
         p1=RRp1, p2=RRp2, data=Plagiarism, etastart=rep(0.01, nrow(Plagiarism)))
RRglmGOF(response ~ Gender + RR + pp + age, data = Plagiarism, glmOutput = out)
}

