% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landscape.R
\name{count_agent_cells}
\alias{count_agent_cells}
\title{Count the number of owned cells of each agent}
\usage{
count_agent_cells(AGENTS, LAND = NULL, tot = 14, own = 3, ID = 1)
}
\arguments{
\item{AGENTS}{The agents array holding agents' information}

\item{LAND}{The landscape on which some cells are owned}

\item{tot}{Column in which the total number of owned cells in AGENTS is added}

\item{own}{Layer of the landscape array where ownership information is held}

\item{ID}{Column in which the ID of an agent is held in the AGENTS array}
}
\value{
The AGENTS array with the column of total cell count filled in.
}
\description{
Counts the total number of cells on a landscape owned by each agent and
inserts that total number into a column of the agents array.
}
\examples{
\dontrun{
agents     <- make_agents(agent_number = 3, type_counts = c(1, 2))
land       <- make_landscape(rows = 10, cols = 10, model = "IBM", 
ownership = 2:3)
new_agents <- count_agent_cells(AGENTS = agents, LAND = land);
}
}
