% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnrs.R
\name{GNRS}
\alias{GNRS}
\title{Standardize political division names}
\usage{
GNRS(political_division_dataframe, batches = NULL, ...)
}
\arguments{
\item{political_division_dataframe}{A properly formatted dataframe, see http://bien.nceas.ucsb.edu/bien/tools/gnrs/gnrs-api/}

\item{batches}{NULL or Numeric.  Optional number of batches to divide the request into for parallel processing.}

\item{...}{Additional parameters passed to internal functions}
}
\value{
Dataframe containing GNRS results.
}
\description{
GNRS returns standardized political division names (according to geonames.org).
}
\note{
To create an empty and properly formatted dataframe, use GNRS_template()

The fields the GNRS takes as input are titled "country", "state_province", and "county_parish" for simplicity, but these field actually refer to 0th-, 1st-, and 2nd-order political division, respectively. In the case of some exceptions (e.g. the UK) this distinction becomes important (e.g. Ireland is a 1st-order political division and should be treated as a "state_province" and cannot be matched as a country.)
}
\examples{
\dontrun{
results <- GNRS(political_division_dataframe = gnrs_testfile)
  

}
}
