% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mostFrequentGOs.R
\name{mostFrequentGOs}
\alias{mostFrequentGOs}
\title{Most frequent GO terms among groups for a data.frame}
\usage{
mostFrequentGOs(df, GOterm_field)
}
\arguments{
\item{df}{A data frame with the results of a functional enrichment analysis
for a species with an extra column "feature" with the features to be compared}

\item{GOterm_field}{This is a string with the column name of the GO terms (e.g; "Functional.Category")}
}
\value{
This function will return a table with the frequency of GO terms per feature
}
\description{
Provides an easy way to get the frequency of GO terms
 such as biological processes for a data frame and a series of features
}
\examples{

#Loading example datasets
data(H_sapiens)
#Defining the column with the GO terms to be compared
GOterm_field <- "Functional_Category"
#Running function
x <- mostFrequentGOs(df=H_sapiens, GOterm_field=GOterm_field)
#Displaying results
head(x)
}
