% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_sd_gp.R
\name{compute_sd_gp}
\alias{compute_sd_gp}
\title{Compute posterior credible interval}
\usage{
compute_sd_gp(
  w,
  scaled_obs,
  hyperparam,
  sigma,
  GPS_m,
  kernel_fn = function(x) exp(-x^2)
)
}
\arguments{
\item{w}{A scalar of exposure level of interest.}

\item{scaled_obs}{A matrix of two columns.
\itemize{
\item First column is the scaled GPS value of all samples (GPS * 1/sqrt(alpha))
\item Second column is the scaled exposure value of all samples (w * 1/sqrt(beta))
}}

\item{hyperparam}{A vector of hyper-parameters for the GP.
\itemize{
\item First element: alpha
\item Second element: beta
\item Third element: gamma/sigma
}}

\item{sigma}{A scaler that represents noise.}

\item{GPS_m}{A data.frame of GPS vectors.
\itemize{
\item Column 1: A vector of estimated GPS evaluated at the observed exposure levels.
\item Column 2: Estimated conditional means of the exposure given covariates
for all samples (e_gps_pred).
\item Column 3: Estimated conditional standard deviation of the exposure given
covariates for all samples (e_gps_std).
}}

\item{kernel_fn}{The covariance function of GP.}
}
\value{
Posterior credible interval (scaler) for the requested exposure level (w).
}
\description{
Computes posterior credible interval for requested exposure level.
}
\keyword{internal}
