% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPPFourier.R
\name{GPPFourierPreprocess}
\alias{GPPFourierPreprocess}
\title{Pre-process O2 data for GPP calculation}
\usage{
GPPFourierPreprocess(x, dt = NULL, units = c("days", "hours", "mins"),
  Detrend = TRUE, filter = TRUE, Nfilt = NULL, circular = FALSE,
  sides = 2)
}
\arguments{
\item{x}{A vector containing consecutive O2 concentrations, sampled at regular intervals (time step = dt).}

\item{dt}{Sampling time step. Class {difftime}, or \code{numeric} when units are provided.}

\item{units}{Units of sampling time step}

\item{Detrend}{Toggle time series detrending}

\item{filter}{Toggle time series filtering}

\item{Nfilt}{Moving average filter width (see documentation of
\code{filter()})}

\item{circular}{Moving average boundary condition (see documentation of
\code{filter()})}

\item{sides}{Moving average central or one sided (see documentation of
\code{filter()})}
}
\value{
A list with components \item{filt}{The long term trend}
\item{res}{The original series without the long term trend, confined to an
integer number of days} \item{indices}{The indices of the subset of the
series that are retained, after filtering and confining to an integer number
of days.}
}
\description{
Removes longer term trend of time series and confine series to integer
number of days
}
\details{
GPPFourierPreprocess() is called by GPPFourier() to pre-process the time series before calculating the Fourier amplitude at diel frequency and estimate GPP.
}
\references{
Cox T.J.S. et al. (2015) 'Estimating primary production from oxygen time series: a novel approach in the frequency domain', Limnology And Oceanography:Methods 13, 529-552. DOI: 10.1002/lom3.10046
}
\seealso{
\code{\link{GPPFourier}}, \code{\link{GPPFourier_t}}, \code{\link{WindowGPPFourier}},
\code{\link{WindowGPPFourier.gts}}
}
\author{
Tom Cox <tom.cox@uantwerp.be>
}
\keyword{utilities}
