\name{GPfit-package}
\alias{GPfit-package}
\alias{GPfit}
\docType{package}
\title{
Gaussian Process Modeling
}
\description{
A computationally stable approach of fitting a Gaussian process (GP) 
model to simulator outputs. It is assumed that the input variables are
continuous and the outputs are obtained from scalar valued deterministic
computer simulator.
}
\details{
This package implements a slightly modified version of the regularized GP model proposed 
in Ranjan et al. (2011). For details see MacDonald et al. (2015). A new parameterization of the Gaussian correlation 
is used for the ease of optimization. This package uses a multi-start gradient
based search algorithm for optimizing the deviance (negative 2*log-likelihood).\cr

For a complete list of functions, use \code{library(help="GPfit")}. \cr
The main function for fitting the GP model is \code{\link{GP_fit}}.
}
\author{
Blake MacDoanld, Hugh Chipman, Pritam Ranjan \cr
Maintainer: Hugh Chipman <hugh.chipman@acadiau.ca>
}
\references{
MacDonald, K.B., Ranjan, P. and Chipman, H. (2015).
GPfit: An R Package for
Fitting a Gaussian Process Model to Deterministic Simulator Outputs.
Journal of Statistical Software, 64(12), 1-23.
\url{http://www.jstatsoft.org/v64/i12/} \cr

Ranjan, P., Haynes, R., and Karsten, R. (2011). A Computationally Stable 
Approach to Gaussian Process Interpolation of Deterministic Computer Simulation Data, 
Technometrics, 53(4), 366 - 378. \cr

Santner, T.J., Williams, B., and Notz, W. (2003), The design and analysis of 
computer experiments, Springer Verlag, New York. \cr
}
