% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poLabs.R
\name{poLabs}
\alias{poLabs}
\title{Polynomial labels order}
\usage{
poLabs(nVar, dMax, findIt = NULL, Xnote = "X")
}
\arguments{
\item{nVar}{The number of variables}

\item{dMax}{The maximum degree allowed in the formulation}

\item{findIt}{A vector of selected terms.}

\item{Xnote}{Enables to defines the notation used for the variable,
by default \code{Xnote = 'X'}.}
}
\value{
\code{lbls} A vector of characters. Each element is the
expression of one polynomial term, such as \eqn{X_1^2 X_3 X_4}
}
\description{
Defines the order of the polynomial labels given
the number of variables \code{nVar} and the maximum polynomial
degree \code{dMax}.
}
\examples{
#Regressor order for three variables \\eqn{(X1,X2,X3)} (nVar = 3) for a maximum
#polynomial degree equal to 2 (dMax = 2): poLabs(3,2)
#and for two variables only : poLabs(2,2)

# For a quadratic equation of two variables,
# the polynomial \\deqn{P(X1,X2) = 0.5 + 0.3 X1 -0.25 X1 X2}
# could thus be written as a vector Pvec such as:
Pvec = c(0.5, 0, 0, 0.3, -0.25, 0)
# considering the convention corresponding to
poLabs(2,2)
# Indeed:
poLabs(2, 2, findIt = Pvec!=0)
# An alternative notation can be used with parameter Xnote
poLabs(2, 2, findIt = Pvec!=0, Xnote = 'w')
# or also
poLabs(2, 2, findIt = Pvec!=0, Xnote = c('x','y'))

}
\seealso{
\code{\link{visuEq}}
}
\author{
Sylvain Mangiarotti
}
