% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructModel.R
\name{constructModel}
\alias{constructModel}
\title{Constructing GP model with the specified kernels}
\usage{
constructModel(x, y, v, kernelTypes, params = NULL)
}
\arguments{
\item{x}{One-column matrix which contains the input
values, i.e., time points for GP models.
The values given in this vector are used in GP model, so if any
transformation is needed, remember to transform them before
constructing the model.}

\item{y}{One-column matrix which contains the observed
values at the corresponding time points given in the \code{x} vector.}

\item{v}{One-column matrix which contains the fixed
variances at the corresponding time points given in the \code{x} vector,
with the corresponding observations given in the \code{y} vector.}

\item{kernelTypes}{Character vector which contains the types of the
kernels which will be used in the GP models.
Kernel types: \code{'rbf'}, \code{'white'}, \code{'bias'}, \code{'fixedvariance'}.
Note that the lower bound for the length scale parameter of rbf kernel
is set to the minimum distance between consecutive time points in order
to mitigate potential overfitting problems.}

\item{params}{Values of the kernel parameters in their transformed form.
If not specified, default values are assigned.}
}
\value{
Return GP model constucted with the specified kernel settings.
}
\description{
Function for constructing the GP model with the specified kernels
(and parameters).
}
\examples{
x=as.matrix(seq(1,10))
y=as.matrix(sin(x))
v=as.matrix(runif(10,0,0.5))
kernelTypes=c("rbf","white","fixedvariance")
model=constructModel(x,y,v,kernelTypes)

}
\author{
Hande Topa, \email{hande.topa@helsinki.fi}
}
\keyword{fixedvariance}
\keyword{model}

