\name{averageCORgvar}
\alias{averageCORgvar}

\title{
Comparing average residual correlations.
}

\encoding{latin1}

\description{Average pairwise cross-section residual correlations.
}

\usage{averageCORgvar(out)
}

\arguments{
  \item{out}{
Estimation results object generated by GVARest
}
}

\details{This function compares the dependency of residuals in VAR and GVAR.
}

\value{

  \item{varRSDcor }{A list object of average residual correlations of country-specific VAR}
  \item{gvarRSDcor}{A list object of average residual correlations of country-specific VAR augmented by foreign variables(GVAR)}

}
\references{Mauro Filippo di and Pesaran H. M. (2013) The GVAR Handbook-- Structure and Applications of a Macro Model of the Global Economy for Policy. Oxford University Press.
}

\author{Ho Tsung-wu <tsungwu@ntnu.edu.tw>, College of Management, National Taiwan Normal University.
}

\examples{
data("PriceVol")
data("tradeweight1")
data("tradeweightx")
p=2
FLag=2
lag.max=15
type="const"
ic="SC"
weight.matrix=tradeweightx
mainOUTPUT = GVARest(data=PriceVol,p,FLag,lag.max,type,ic,weight.matrix)

cor2_avg=averageCORgvar(out=mainOUTPUT)
as.matrix((cor2_avg$varRSDcor)[[1]])
as.matrix((cor2_avg$varRSDcor)[[2]])

as.matrix(cor2_avg$gvarRSDcor[[1]])
as.matrix(cor2_avg$gvarRSDcor[[2]])

}
