% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWexPrec_lib.r
\name{getGwexFitPrec}
\alias{getGwexFitPrec}
\title{getGwexFitPrec}
\usage{
getGwexFitPrec(
  listOption = NULL,
  p,
  condProbaWDstates,
  parMargin,
  vec.ar1 = NULL,
  M0 = NULL,
  mat.omega = NULL
)
}
\arguments{
\item{listOption}{list of options (see \code{\link{fitGwexModel}})}

\item{p}{number of stations}

\item{condProbaWDstates}{vector of length nLag^2 of transition probabilities
corresponding to the nlag possible transitions between dry/wet states
\code{expand.grid(lapply(numeric(nLag), function(x) c(F,T)))}}

\item{parMargin}{parameters of the margins: vector of length 3}

\item{vec.ar1}{vector of observed autocorrelations for all stations}

\item{M0}{\strong{M0}: covariance matrix of gaussianized prec. amounts for all pairs of stations}

\item{mat.omega}{\strong{mat.omega}: The spatial correlation matrix of occurrences \eqn{\Omega}}
}
\value{
Return an object of class \code{\linkS4class{GwexFit}} with:
\itemize{
  \item \strong{p}: The number of station,
  \item \strong{version}: package version,
  \item \strong{variable}: the type of variable,
  \item \strong{fit}: a list containing the list of options \code{listOption}
   and the list of estimated parameters \code{listPar}.
}
}
\description{
get object GwexFit derived from the parameters replicated for each month
}
\examples{
exFitGwexPrec = getGwexFitPrec(p=2,condProbaWDstates=c(0.7,0.3,0.2,0.1),
parMargin=c(0.5,0.1,0.4),vec.ar1=rep(0.7,2),M0=rbind(c(1,0.6),c(0.6,1)),
mat.omega=rbind(c(1,0.8),c(0.8,1)))
}
