% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_hessian.R
\name{Gaussian_hessianC}
\alias{Gaussian_hessianC}
\title{Calculate Hessian for a GP with Gaussian correlation}
\usage{
Gaussian_hessianC(XX, X, Z, Kinv, mu_hat, theta)
}
\arguments{
\item{XX}{The vector at which to calculate the Hessian}

\item{X}{The input points}

\item{Z}{The output values}

\item{Kinv}{The inverse of the correlation matrix}

\item{mu_hat}{Estimate of mu}

\item{theta}{Theta parameters for the correlation}
}
\value{
Matrix, the Hessian at XX
}
\description{
Calculate Hessian for a GP with Gaussian correlation
}
\examples{
set.seed(0)
n <- 40
x <- matrix(runif(n*2), ncol=2)
f1 <- function(a) {sin(2*pi*a[1]) + sin(6*pi*a[2])}
y <- apply(x,1,f1) + rnorm(n,0,.01)
gp <- GauPro(x,y, verbose=2, parallel=FALSE);gp$theta
gp$hessian(c(.2,.75), useC=TRUE) # Should be -38.3, -5.96, -5.96, -389.4 as 2x2 matrix
}
