% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compare_release}
\alias{compare_release}
\title{Compare Annotation Counts Between Two GENCODE Releases}
\usage{
compare_release(input1, input2, type, gene_type = NULL, baseline = "count2")
}
\arguments{
\item{input1}{A character string specifying the file path to a GTF/GFF file from the first GENCODE release, or a data frame containing the annotation data.}

\item{input2}{A character string specifying the file path to a GTF/GFF file from the second GENCODE release, or a data frame containing the annotation data.}

\item{type}{A character string indicating the type of genomic element to compare. Valid options are \code{"gene"}, \code{"transcript"}, \code{"exon"}, or \code{"intron"}.}

\item{gene_type}{An optional character string specifying a particular gene biotype to filter comparisons (e.g., \code{"protein_coding"}, \code{"lncRNA"}). If \code{NULL} (default), all gene types are included.}

\item{baseline}{A character string defining the baseline for calculating percentage change. Options include:
\itemize{
\item \code{"count1"}: Uses the count from the first input (release) as the baseline.
\item \code{"count2"}: Uses the count from the second input (release) as the baseline (default).
\item \code{"average"}: Uses the average of the counts from both inputs as the baseline.
}}
}
\value{
A list with the following elements:
\itemize{
\item \code{delta}: The absolute difference in the number of annotations.
\item \code{percentage}: The percentage change relative to the selected baseline.
\item \code{direction}: A string indicating the direction of the change ("increase", "decrease", or "no change").
}
}
\description{
Compares the number of annotated genomic elements (genes, transcripts, exons, introns) between two specified GENCODE releases. The function accepts input data as either file paths (in GTF/GFF format) or pre-loaded data frames. It computes the absolute difference (delta), the percentage change relative to a chosen baseline, and determines the direction of change (increase or decrease).
}
\details{
This function processes two GENCODE releases to compare annotation counts for a specified genomic element type. Key steps include:
\enumerate{
\item Input Handling: If inputs are file paths, they are loaded into data frames using the \code{load_file} function. Data frames are used directly.
\item Element Filtering: If \code{gene_type} is specified, annotations are filtered to include only that gene biotype.
\item Count Calculation: The number of elements (genes, transcripts, etc.) of the specified type is counted in each release.
\item Delta and Percentage: The absolute difference (delta) and percentage change are calculated based on the chosen baseline.
\item Direction Determination: The direction of change is determined by comparing counts between the two releases.
}
The function provides both numerical results and a formatted console output highlighting key metrics.
}
\examples{
file_v1 <- system.file("extdata", "gencode.v1.example.gtf.gz", package = "GencoDymo2")
file_v2 <- system.file("extdata", "gencode.v2.example.gtf.gz", package = "GencoDymo2")
# Example 1: Using data frames with the provided example GTF files
gtf_v1 <- load_file(file_v1)
gtf_v2 <- load_file(file_v2)
comparison <- compare_release(gtf_v1, gtf_v2, type = "gene")


}
\seealso{
\code{\link{load_file}}, \code{\link{get_gtf}}, \code{\link{get_gff3}}.
}
