% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPred.R
\name{plotPred}
\alias{plotPred}
\title{Plots the predictions and the corresponding uncertainty (coefficient of
variation), and saves them into the preferred directory as separate .pdf files.}
\usage{
plotPred(
  pred = NULL,
  predRaster = NULL,
  admin0 = NULL,
  admin1 = NULL,
  admin2 = NULL,
  rmPoly = NULL,
  locObs = NULL
)
}
\arguments{
\item{pred}{A matrix that is the output of predRes() function.}

\item{predRaster}{The prediction raster that is constructed by the gridCountry() function.}

\item{admin0}{A SpatialPolygonsDataFrame representing the national level (admin0) borders of the country.}

\item{admin1}{A SpatialPolygonsDataFrame representing the first level (admin1) subnational borders of the country.}

\item{admin2}{A SpatialPolygonsDataFrame representing the second level (admin2) subnational borders of the country.}

\item{rmPoly}{A number referring to the ID number of the admin2 level polygon that needs to be left uncolored. It can be set to NULL as well.}

\item{locObs}{A data frame containing the coordinates of the observation points (DHS locations) in kilometers.}
}
\value{
Plots two ggplot objects. One of them (pred.) shows the median predictions and the other one (cv%) shows the
corresponding coefficient of variations across the country, respectively.
}
\description{
Plots the predictions and the corresponding uncertainty (coefficient of
variation), and saves them into the preferred directory as separate .pdf files.
}
\examples{
path1 <- system.file("extdata", "examplePredictionResults.rda", package = "GeoAdjust")
path2 <- system.file("extdata", "exampleGrid.rda", package = "GeoAdjust")
path3 <- system.file("extdata", "geoData.rda", package = "GeoAdjust")
load(path1)
load(path2)
load(path3)
plotPred(pred = examplePredictionResults,
predRaster = exampleGrid[["predRast"]], admin0 = adm0,
admin1 = adm1, admin2 = NULL, rmPoly = NULL,
locObs = data.frame(East = surveyData$east, North = surveyData$north))
}
