% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brute_force_thinning.R
\name{brute_force_thinning}
\alias{brute_force_thinning}
\title{Perform Brute Force Thinning}
\usage{
brute_force_thinning(
  coordinates,
  thin_dist = 10,
  trials = 10,
  all_trials = FALSE,
  target_points = NULL,
  euclidean = FALSE,
  R = 6371
)
}
\arguments{
\item{coordinates}{A numeric matrix or data frame with two columns representing longitude and latitude (or XY coordinates if `euclidean = TRUE`).}

\item{thin_dist}{Numeric value representing the thinning distance in kilometers (default: 10 km).}

\item{trials}{Integer specifying the number of trials to run for thinning (default: 10).}

\item{all_trials}{Logical value indicating whether to return the results of all trials (`TRUE`) or just the best attempt with the most points retained (`FALSE`, default).}

\item{target_points}{Optional integer specifying the number of points to retain. If `NULL` (default), the function tries to maximize the number of points retained.}

\item{euclidean}{Logical value indicating whether to compute the Euclidean distance (`TRUE`) or Haversine distance (`FALSE`, default).}

\item{R}{Numeric value representing the Earth's radius in kilometers (default: 6371 km). Only used if `euclidean = FALSE`.}
}
\value{
A logical vector indicating which points are kept in the best trial if `all_trials = FALSE`; otherwise, a list of logical vectors for each trial.
}
\description{
This function applies a brute force algorithm to thin a set of spatial coordinates, attempting to maximize the number of points retained while ensuring a minimum distance (`thin_dist`) between any two points.
}
\examples{
# Example with geographic coordinates (Haversine distance)
coords <- data.frame(
  long = c(-122.4194, -122.4195, -122.4196),
  lat = c(37.7749, 37.7740, 37.7741)
)
coords <- as.matrix(coords)

result <- brute_force_thinning(coords, thin_dist = 0.1, trials = 5)
print(result)

# Example computing Euclidean distance
result_euclidean <- brute_force_thinning(coords, thin_dist = 1, trials = 5, euclidean = TRUE)
print(result_euclidean)
}
