% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdfpd_fix_dataframes.R
\name{gdfpd.fix.DFP.dataframes}
\alias{gdfpd.fix.DFP.dataframes}
\title{Fix dataframe for version issues and inflation measures (internal)}
\usage{
gdfpd.fix.DFP.dataframes(df.in, inflation.index, df.inflation, max.levels = 3)
}
\arguments{
\item{df.in}{A dataframe with financial statements}

\item{inflation.index}{Sets the inflation index to use for finding inflation adjusted values of all reports. Possible values: 'dollar' (default) or 'IPCA', the brazilian main inflation index.
When using 'IPCA', the base date is set as the last date found in the DFP dataset.}

\item{df.inflation}{Dataframe with inflation data}

\item{max.levels}{Sets the maximum number of levels of accounting items in financial reports (default = 3)}
}
\value{
The fixed data.frame
}
\description{
Fix dataframe for version issues and inflation measures (internal)
}
\examples{
#'
# get example data from RData file
my.f <- system.file('extdata/Example_DFP_Report_Petrobras.RData', package = 'GetDFPData')
load(my.f)

df.assets <- df.reports$fr.assets[[1]]
df.inflation <- gdfpd.get.inflation.data('dollar', do.cache = FALSE)

df.assets.fixed <- gdfpd.fix.DFP.dataframes(df.assets,
                                        inflation.index = 'dollar',
                                        df.inflation = df.inflation)
}
